/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import NIST.NIST_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class NIST_Algorithm {
    static final String NAME = "NIST_Algorithm";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = true;
    static final int debuglevel = NIST_Properties.getLevel("NIST_Algorithm");
    static final PrintWriter err = NIST_Properties.getOutput();
    static final boolean TRACE = NIST_Properties.isTraceable("NIST_Algorithm");
    static final int BLOCK_SIZE = 16;

    static void debug(String s) {
        err.println(">>> NIST_Algorithm: " + s);
    }

    static void trace(boolean in, String s) {
        if (TRACE) {
            err.println(String.valueOf(in ? "==> " : "<== ") + NAME + "." + s);
        }
    }

    static void trace(String s) {
        if (TRACE) {
            err.println("<=> NIST_Algorithm." + s);
        }
    }

    public static int blockSize() {
        return 16;
    }

    public static synchronized Object makeKey(byte[] k) throws InvalidKeyException {
        NIST_Algorithm.trace(true, "makeKey(" + k + ")");
        Object sessionKey = null;
        NIST_Algorithm.trace(false, "makeKey()");
        return sessionKey;
    }

    public static byte[] blockEncrypt(byte[] in, int inOffset, Object sessionKey) {
        NIST_Algorithm.trace(true, "blockEncrypt(" + in + ", " + inOffset + ", " + sessionKey + ")");
        byte[] result = new byte[16];
        System.arraycopy(in, inOffset, result, 0, 16);
        NIST_Algorithm.trace(false, "blockEncrypt()");
        return result;
    }

    public static byte[] blockDecrypt(byte[] in, int inOffset, Object sessionKey) {
        NIST_Algorithm.trace(true, "blockDecrypt(" + in + ", " + inOffset + ", " + sessionKey + ")");
        byte[] result = new byte[16];
        System.arraycopy(in, inOffset, result, 0, 16);
        NIST_Algorithm.trace(false, "blockDecrypt()");
        return result;
    }

    public static boolean self_test() {
        NIST_Algorithm.trace(true, "self_test()");
        boolean ok = false;
        try {
            byte[] kb = new byte[16];
            byte[] pt = new byte[16];
            int i = 0;
            while (i < 16) {
                kb[i] = (byte)i;
                ++i;
            }
            i = 0;
            while (i < 16) {
                pt[i] = (byte)i;
                ++i;
            }
            Object key = NIST_Algorithm.makeKey(kb);
            byte[] ct = NIST_Algorithm.blockEncrypt(pt, 0, key);
            byte[] cpt = NIST_Algorithm.blockDecrypt(ct, 0, key);
            ok = NIST_Algorithm.areEqual(pt, cpt);
            if (!ok) {
                throw new RuntimeException("Symmetric operation failed");
            }
        }
        catch (Exception x) {
            NIST_Algorithm.debug("Exception encountered during self-test: " + x.getMessage());
            x.printStackTrace();
        }
        NIST_Algorithm.debug("Self-test OK? " + ok);
        NIST_Algorithm.trace(false, "self_test()");
        return ok;
    }

    private static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

