/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import NIST.NIST_CipherSpi;
import NIST.NIST_Properties;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;

public final class NIST_CBC
implements NIST_CipherSpi {
    static final String NAME = "NIST_CBC";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = true;
    static final int debuglevel = NIST_Properties.getLevel("NIST_CBC");
    static final PrintWriter err = NIST_Properties.getOutput();
    static final boolean TRACE = NIST_Properties.isTraceable("NIST_CBC");
    private static final int BLOCK_SIZE = 16;
    private transient Object sessionKey;
    private transient byte[] buffer;
    private transient int buffered;
    private int state;
    protected transient byte[] iv;
    protected transient byte[] userIV;
    private Method makeKey;
    private Method encrypt;
    private Method decrypt;
    private Object[] args;
    private String aes;

    static void debug(String s) {
        err.println(">>> NIST_CBC: " + s);
    }

    static void trace(boolean in, String s) {
        if (TRACE) {
            err.println(String.valueOf(in ? "==> " : "<== ") + NAME + "." + s);
        }
    }

    static void trace(String s) {
        if (TRACE) {
            err.println("<=> NIST_CBC." + s);
        }
    }

    protected NIST_CBC(String aes) throws ClassNotFoundException, NoSuchMethodException {
        try {
            aes = String.valueOf(aes) + "." + aes + "_Algorithm";
            Class<?> algorithm = Class.forName(aes);
            Method[] methods = algorithm.getDeclaredMethods();
            int i = 0;
            int n = methods.length;
            while (i < n) {
                String name = methods[i].getName();
                int params = methods[i].getParameterTypes().length;
                if (name.equals("makeKey") && params == 1) {
                    this.makeKey = methods[i];
                } else if (name.equals("blockEncrypt") && params == 3) {
                    this.encrypt = methods[i];
                } else if (name.equals("blockDecrypt") && params == 3) {
                    this.decrypt = methods[i];
                }
                ++i;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException x1) {
            NIST_CBC.debug("Class " + aes + " not found");
            throw (ClassNotFoundException)x1.fillInStackTrace();
        }
        catch (NoSuchMethodException x2) {
            NIST_CBC.debug("Method " + aes + "." + x2.getMessage() + " not found");
            throw (NoSuchMethodException)x2.fillInStackTrace();
        }
        this.aes = aes;
        this.buffer = new byte[16];
        this.buffered = 0;
        this.sessionKey = null;
        this.userIV = null;
        this.iv = new byte[16];
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void init(int state, byte[] key) throws InvalidKeyException {
        NIST_CBC.trace(true, "init()");
        this.generateKey(key);
        this.engineInit();
        this.state = state;
        NIST_CBC.trace(false, "init()");
    }

    public void setIV(byte[] iv) throws InvalidParameterException {
        NIST_CBC.trace(true, "setIV(" + iv + ")");
        if ((this.state == 1 || this.state == 2) && this.userIV != null) {
            throw new IllegalStateException();
        }
        if (iv.length != 16) {
            throw new InvalidParameterException(String.valueOf(iv.length));
        }
        this.userIV = (byte[])iv.clone();
        this.iv = (byte[])this.userIV.clone();
        NIST_CBC.trace(false, "setIV()");
    }

    public byte[] update(byte[] in, int inOff, int inLen) {
        NIST_CBC.trace(true, "update(" + in + ", " + inOff + ", " + inLen + ")");
        if (this.iv == null) {
            throw new NullPointerException("IV");
        }
        byte[] out = new byte[16 * ((inLen + this.buffered) / 16)];
        int outOff = 0;
        int i = 0;
        while (i < inLen) {
            this.buffer[this.buffered++] = in[inOff++];
            if (this.buffered >= 16) {
                byte[] temp = this.processBuffer();
                System.arraycopy(temp, 0, out, outOff, temp.length);
                outOff += temp.length;
            }
            ++i;
        }
        NIST_CBC.trace(false, "update()");
        return out;
    }

    public byte[] doFinal(byte[] in, int inOff, int inLen) {
        NIST_CBC.trace(true, "doFinal(" + in + ", " + inOff + ", " + inLen + ")");
        if ((inLen + this.buffered) % 16 != 0) {
            throw new InvalidParameterException();
        }
        byte[] out = this.update(in, inOff, inLen);
        this.state = 0;
        NIST_CBC.trace(false, "doFinal()");
        return out;
    }

    public boolean self_test() {
        NIST_CBC.trace(true, "self_test()");
        boolean ok = false;
        try {
            byte[] byArray = new byte[16];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byArray[9] = 1;
            byArray[10] = 2;
            byArray[11] = 3;
            byArray[12] = 4;
            byArray[13] = 5;
            byArray[14] = 6;
            byArray[15] = 7;
            byte[] key = byArray;
            byte[] byArray2 = new byte[16];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 4;
            byArray2[5] = 5;
            byArray2[6] = 6;
            byArray2[7] = 7;
            byArray2[9] = 1;
            byArray2[10] = 2;
            byArray2[11] = 3;
            byArray2[12] = 4;
            byArray2[13] = 5;
            byArray2[14] = 6;
            byArray2[15] = 7;
            byte[] iv = byArray2;
            byte[] byArray3 = new byte[48];
            byArray3[1] = 1;
            byArray3[2] = 2;
            byArray3[3] = 3;
            byArray3[4] = 4;
            byArray3[5] = 5;
            byArray3[6] = 6;
            byArray3[7] = 7;
            byArray3[9] = 1;
            byArray3[10] = 2;
            byArray3[11] = 3;
            byArray3[12] = 4;
            byArray3[13] = 5;
            byArray3[14] = 6;
            byArray3[15] = 7;
            byArray3[17] = 1;
            byArray3[18] = 2;
            byArray3[19] = 3;
            byArray3[20] = 4;
            byArray3[21] = 5;
            byArray3[22] = 6;
            byArray3[23] = 7;
            byArray3[25] = 1;
            byArray3[26] = 2;
            byArray3[27] = 3;
            byArray3[28] = 4;
            byArray3[29] = 5;
            byArray3[30] = 6;
            byArray3[31] = 7;
            byArray3[33] = 1;
            byArray3[34] = 2;
            byArray3[35] = 3;
            byArray3[36] = 4;
            byArray3[37] = 5;
            byArray3[38] = 6;
            byArray3[39] = 7;
            byArray3[41] = 1;
            byArray3[42] = 2;
            byArray3[43] = 3;
            byArray3[44] = 4;
            byArray3[45] = 5;
            byArray3[46] = 6;
            byArray3[47] = 7;
            byte[] input = byArray3;
            NIST_CBC cipher = new NIST_CBC("NIST");
            cipher.setIV(iv);
            cipher.init(1, key);
            byte[] ct1 = cipher.doFinal(input, 0, input.length);
            int i = input.length / 2 - 3;
            cipher.init(1, key);
            byte[] ct2 = new byte[ct1.length];
            byte[] t1 = cipher.update(input, 0, i);
            byte[] t2 = cipher.doFinal(input, i, input.length - i);
            System.arraycopy(t1, 0, ct2, 0, t1.length);
            System.arraycopy(t2, 0, ct2, t1.length, t2.length);
            ok = NIST_CBC.areEqual(ct1, ct2);
            if (!ok) {
                throw new RuntimeException("Level-1 API CBC encryption failed");
            }
        }
        catch (Exception x) {
            NIST_CBC.debug("Exception encountered during self-test: " + x.getMessage());
            x.printStackTrace();
            return false;
        }
        NIST_CBC.debug("Self-test OK? " + ok);
        NIST_CBC.trace(false, "self_test()");
        return true;
    }

    private void generateKey(byte[] key) throws InvalidKeyException {
        NIST_CBC.trace(true, "generateKey(" + key + ")");
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        int length = key.length;
        if (length != 16 && length != 24 && length != 32) {
            throw new InvalidKeyException("Incorrect length: " + length);
        }
        this.args = new Object[]{key};
        try {
            this.sessionKey = this.makeKey.invoke(null, this.args);
        }
        catch (IllegalAccessException x1) {
            NIST_CBC.debug("Illegal access to method " + this.aes + ".makeKey()");
            throw new InvalidKeyException(x1.getMessage());
        }
        catch (InvocationTargetException x2) {
            NIST_CBC.debug("Exception occured in method " + this.aes + ".makeKey()");
            throw new InvalidKeyException(x2.getMessage());
        }
        NIST_CBC.trace(false, "generateKey()");
    }

    private void engineInit() {
        int i = 0;
        while (i < 16) {
            this.buffer[i++] = 0;
        }
        this.buffered = 0;
        if (this.userIV != null) {
            this.iv = (byte[])this.userIV.clone();
        }
    }

    private byte[] processBuffer() {
        byte[] result;
        switch (this.state) {
            case 1: {
                int i = 0;
                while (i < 16) {
                    int n = i;
                    this.iv[n] = (byte)(this.iv[n] ^ this.buffer[i]);
                    ++i;
                }
                this.args = new Object[]{this.iv, new Integer(0), this.sessionKey};
                try {
                    this.iv = (byte[])this.encrypt.invoke(null, this.args);
                }
                catch (Exception x) {
                    NIST_CBC.debug("Exception occured during encryption");
                    x.printStackTrace();
                    throw new RuntimeException(x.getMessage());
                }
                result = (byte[])this.iv.clone();
                break;
            }
            case 2: {
                byte[] temp = (byte[])this.buffer.clone();
                this.args = new Object[]{this.buffer, new Integer(0), this.sessionKey};
                try {
                    result = (byte[])this.decrypt.invoke(null, this.args);
                }
                catch (Exception x) {
                    NIST_CBC.debug("Exception occured during decryption");
                    x.printStackTrace();
                    throw new RuntimeException(x.getMessage());
                }
                int i = 0;
                while (i < 16) {
                    int n = i;
                    result[n] = (byte)(result[n] ^ this.iv[i]);
                    ++i;
                }
                System.arraycopy(temp, 0, this.iv, 0, 16);
                temp = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.engineInit();
        return result;
    }

    private static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        NIST_CBC.trace(true, "main()");
        try {
            NIST_CBC.debug("Self-test OK? " + new NIST_CBC("NIST").self_test());
        }
        catch (Exception x) {
            System.err.println("Exception occured: " + x.getMessage());
            x.printStackTrace();
        }
        NIST_CBC.trace(false, "main()");
    }
}

