/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import NIST.NIST_CipherSpi;
import NIST.NIST_Properties;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;

public final class NIST_CFB
implements NIST_CipherSpi {
    static final String NAME = "NIST_CFB";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = true;
    static final int debuglevel = NIST_Properties.getLevel("NIST_CFB");
    static final PrintWriter err = NIST_Properties.getOutput();
    static final boolean TRACE = NIST_Properties.isTraceable("NIST_CFB");
    private static final int BLOCK_SIZE = 16;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private transient Object sessionKey;
    private transient byte[] iv;
    protected transient byte[] userIV;
    private int state;
    private Method makeKey;
    private Method encrypt;
    private Method decrypt;
    private Object[] args;
    private String aes;

    static void debug(String s) {
        err.println(">>> NIST_CFB: " + s);
    }

    static void trace(boolean in, String s) {
        if (TRACE) {
            err.println(String.valueOf(in ? "==> " : "<== ") + NAME + "." + s);
        }
    }

    static void trace(String s) {
        if (TRACE) {
            err.println("<=> NIST_CFB." + s);
        }
    }

    protected NIST_CFB(String aes) throws ClassNotFoundException, NoSuchMethodException {
        try {
            aes = String.valueOf(aes) + "." + aes + "_Algorithm";
            Class<?> algorithm = Class.forName(aes);
            Method[] methods = algorithm.getDeclaredMethods();
            int i = 0;
            int n = methods.length;
            while (i < n) {
                String name = methods[i].getName();
                int params = methods[i].getParameterTypes().length;
                if (name.equals("makeKey") && params == 1) {
                    this.makeKey = methods[i];
                } else if (name.equals("blockEncrypt") && params == 3) {
                    this.encrypt = methods[i];
                } else if (name.equals("blockDecrypt") && params == 3) {
                    this.decrypt = methods[i];
                }
                ++i;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException x1) {
            NIST_CFB.debug("Class " + aes + " not found");
            throw (ClassNotFoundException)x1.fillInStackTrace();
        }
        catch (NoSuchMethodException x2) {
            NIST_CFB.debug("Method " + aes + "." + x2.getMessage() + " not found");
            throw (NoSuchMethodException)x2.fillInStackTrace();
        }
        this.aes = aes;
        this.userIV = null;
        this.iv = new byte[16];
        this.sessionKey = null;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void init(int state, byte[] key) throws InvalidKeyException {
        NIST_CFB.trace(true, "init()");
        this.generateKey(key);
        this.engineInit();
        this.state = state;
        NIST_CFB.trace(false, "init()");
    }

    public void setIV(byte[] iv) throws InvalidParameterException {
        NIST_CFB.trace(true, "setIV(" + (iv[0] & 1) + ")");
        if ((this.state == 1 || this.state == 2) && this.userIV != null) {
            throw new IllegalStateException();
        }
        if (iv.length != 16) {
            throw new InvalidParameterException(String.valueOf(iv.length));
        }
        this.userIV = (byte[])iv.clone();
        this.iv = (byte[])this.userIV.clone();
        NIST_CFB.trace(false, "setIV()");
    }

    public byte[] update(byte[] in, int inOff, int inLen) {
        NIST_CFB.trace(true, "update(" + in + ", " + inOff + ", " + inLen + ")");
        if (this.iv == null) {
            throw new NullPointerException("IV");
        }
        byte[] out = new byte[inLen];
        int outOff = 0;
        switch (this.state) {
            case 1: {
                int i = 0;
                while (i < inLen) {
                    out[outOff++] = this.byteEncrypt(in[inOff++] & 0xFF);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < inLen) {
                    out[outOff++] = this.byteDecrypt(in[inOff++] & 0xFF);
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        NIST_CFB.trace(false, "update()");
        return out;
    }

    public byte[] doFinal(byte[] in, int inOff, int inLen) {
        NIST_CFB.trace(true, "doFinal(" + in + ", " + inOff + ", " + inLen + ")");
        byte[] out = this.update(in, inOff, inLen);
        this.state = 0;
        NIST_CFB.trace(false, "doFinal()");
        return out;
    }

    public boolean self_test() {
        NIST_CFB.trace(true, "self_test()");
        boolean ok = false;
        try {
            byte[] byArray = new byte[16];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byArray[9] = 1;
            byArray[10] = 2;
            byArray[11] = 3;
            byArray[12] = 4;
            byArray[13] = 5;
            byArray[14] = 6;
            byArray[15] = 7;
            byte[] key = byArray;
            byte[] byArray2 = new byte[16];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 4;
            byArray2[5] = 5;
            byArray2[6] = 6;
            byArray2[7] = 7;
            byArray2[9] = 1;
            byArray2[10] = 2;
            byArray2[11] = 3;
            byArray2[12] = 4;
            byArray2[13] = 5;
            byArray2[14] = 6;
            byArray2[15] = 7;
            byte[] iv = byArray2;
            byte[] byArray3 = new byte[21];
            byArray3[1] = 1;
            byArray3[2] = 2;
            byArray3[3] = 3;
            byArray3[4] = 4;
            byArray3[5] = 5;
            byArray3[6] = 6;
            byArray3[7] = 7;
            byArray3[9] = 1;
            byArray3[10] = 2;
            byArray3[11] = 3;
            byArray3[12] = 4;
            byArray3[13] = 5;
            byArray3[14] = 6;
            byArray3[15] = 7;
            byArray3[17] = 1;
            byArray3[18] = 2;
            byArray3[19] = 3;
            byArray3[20] = 4;
            byte[] pt = byArray3;
            NIST_CFB cipher = new NIST_CFB("NIST");
            cipher.setIV(iv);
            cipher.init(1, key);
            byte[] ct = cipher.doFinal(pt, 0, pt.length);
            NIST_CFB.debug(" plain text: " + NIST_CFB.toString(pt));
            cipher.init(2, key);
            byte[] cpt = cipher.doFinal(ct, 0, ct.length);
            NIST_CFB.debug("plain2 text: " + NIST_CFB.toString(cpt));
            ok = NIST_CFB.areEqual(pt, cpt);
            if (!ok) {
                throw new RuntimeException("Level-1 API CFB failed");
            }
        }
        catch (Exception x) {
            NIST_CFB.debug("Exception encountered during self-test: " + x.getMessage());
            x.printStackTrace();
            return false;
        }
        NIST_CFB.debug("Self-test OK? " + ok);
        NIST_CFB.trace(false, "self_test()");
        return true;
    }

    private void generateKey(byte[] key) throws InvalidKeyException {
        NIST_CFB.trace(true, "generateKey(" + key + ")");
        if (key == null) {
            throw new InvalidKeyException("Null key");
        }
        int length = key.length;
        if (length != 16 && length != 24 && length != 32) {
            throw new InvalidKeyException("Incorrect length: " + length);
        }
        this.args = new Object[]{key};
        try {
            this.sessionKey = this.makeKey.invoke(null, this.args);
        }
        catch (IllegalAccessException x1) {
            NIST_CFB.debug("Illegal access to method " + this.aes + ".makeKey()");
            throw new InvalidKeyException(x1.getMessage());
        }
        catch (InvocationTargetException x2) {
            NIST_CFB.debug("Exception occured in method " + this.aes + ".makeKey()");
            throw new InvalidKeyException(x2.getMessage());
        }
        NIST_CFB.trace(false, "generateKey()");
    }

    private void engineInit() {
        if (this.userIV != null) {
            this.iv = (byte[])this.userIV.clone();
        }
    }

    private byte byteEncrypt(int pt) {
        int Ci = 0;
        int j = 0;
        while (j < 8) {
            int Ki;
            this.args = new Object[]{this.iv, new Integer(0), this.sessionKey};
            try {
                byte[] ciphertext = (byte[])this.encrypt.invoke(null, this.args);
                Ki = ciphertext[0] >>> 7 & 1;
            }
            catch (Exception x) {
                NIST_CFB.debug("Exception occured during encryption");
                x.printStackTrace();
                throw new RuntimeException(x.getMessage());
            }
            int Pi = pt >>> 7 - j & 1;
            int bit = (Ki ^ Pi) & 1;
            int i = 0;
            while (i < 16) {
                this.iv[i] = (byte)((this.iv[i] & 0xFF) << 1 | (i != 15 ? (this.iv[i + 1] & 0x80) >>> 7 : bit));
                ++i;
            }
            Ci |= bit << 7 - j;
            ++j;
        }
        return (byte)Ci;
    }

    private byte byteDecrypt(int ct) {
        int Pi = 0;
        int j = 0;
        while (j < 8) {
            int Ki;
            this.args = new Object[]{this.iv, new Integer(0), this.sessionKey};
            try {
                byte[] plaintext = (byte[])this.encrypt.invoke(null, this.args);
                Ki = plaintext[0] >>> 7 & 1;
            }
            catch (Exception x) {
                NIST_CFB.debug("Exception occured during decryption");
                x.printStackTrace();
                throw new RuntimeException(x.getMessage());
            }
            int Ci = ct >>> 7 - j & 1;
            int bit = (Ki ^ Ci) & 1;
            int i = 0;
            while (i < 16) {
                this.iv[i] = (byte)((this.iv[i] & 0xFF) << 1 | (i != 15 ? (this.iv[i + 1] & 0x80) >>> 7 : Ci));
                ++i;
            }
            Pi |= bit << 7 - j;
            ++j;
        }
        return (byte)Pi;
    }

    private static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String toString(byte[] ba) {
        int length = ba.length;
        char[] buf = new char[length * 2];
        int i = 0;
        int j = 0;
        while (i < length) {
            byte k = ba[i++];
            buf[j++] = HEX_DIGITS[k >>> 4 & 0xF];
            buf[j++] = HEX_DIGITS[k & 0xF];
        }
        return new String(buf);
    }

    public static void main(String[] args) {
        NIST_CFB.trace(true, "main()");
        try {
            NIST_CFB.debug("Self-test OK? " + new NIST_CFB("NIST").self_test());
        }
        catch (Exception x) {
            System.err.println("Exception occured: " + x.getMessage());
            x.printStackTrace();
        }
        NIST_CFB.trace(false, "main()");
    }
}

