/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import NIST.NIST_CBC;
import NIST.NIST_CFB;
import NIST.NIST_CipherSpi;
import NIST.NIST_ECB;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;

public final class NIST_Cipher {
    public static final int ENCRYPT_STATE = 1;
    public static final int DECRYPT_STATE = 2;
    public static final int ECB_MODE = 1;
    public static final int CBC_MODE = 2;
    public static final int CFB_1BIT_MODE = 3;
    NIST_CipherSpi cipher;

    public NIST_Cipher(String aes, int mode) throws ClassNotFoundException, NoSuchMethodException {
        String suffix;
        switch (mode) {
            case 1: {
                suffix = "ECB";
                break;
            }
            case 2: {
                suffix = "CBC";
                break;
            }
            case 3: {
                suffix = "CFB";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid feedback mode: " + mode);
            }
        }
        boolean ok = false;
        String className = "";
        try {
            System.err.println("Attempting to use Extended API...");
            className = String.valueOf(aes) + "." + aes + "_" + suffix;
            Class<?> clazz = Class.forName(className);
            this.cipher = (NIST_CipherSpi)clazz.newInstance();
            ok = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: " + className);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Exception while instantiating: " + className);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Illegal access to: " + className);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println("Does not exist or does not have a no-argument constructor: " + className);
        }
        if (!ok) {
            System.err.println("Attempting to use Basic API...");
            switch (mode) {
                case 1: {
                    this.cipher = new NIST_ECB(aes);
                    break;
                }
                case 2: {
                    this.cipher = new NIST_CBC(aes);
                    break;
                }
                case 3: {
                    this.cipher = new NIST_CFB(aes);
                    break;
                }
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void init(int state, byte[] key) throws InvalidKeyException {
        this.cipher.init(state, key);
    }

    public void setIV(byte[] iv) throws InvalidParameterException {
        this.cipher.setIV(iv);
    }

    public byte[] update(byte[] in, int inOff, int inLen) {
        return this.cipher.update(in, inOff, inLen);
    }

    public byte[] doFinal(byte[] in, int inOff, int inLen) {
        return this.cipher.doFinal(in, inOff, inLen);
    }

    private void test() {
        System.err.println("Underlying cipher self test(s) OK? " + this.cipher.self_test());
    }

    private static boolean areEqual(byte[] a, byte[] b) {
        int aLength = a.length;
        if (aLength != b.length) {
            return false;
        }
        int i = 0;
        while (i < aLength) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            NIST_Cipher cipher = new NIST_Cipher("NIST", 1);
            cipher.test();
            cipher = new NIST_Cipher("NIST", 2);
            cipher.test();
            cipher = new NIST_Cipher("NIST", 3);
            cipher.test();
            byte[] byArray = new byte[16];
            byArray[1] = 1;
            byArray[2] = 2;
            byArray[3] = 3;
            byArray[4] = 4;
            byArray[5] = 5;
            byArray[6] = 6;
            byArray[7] = 7;
            byArray[9] = 1;
            byArray[10] = 2;
            byArray[11] = 3;
            byArray[12] = 4;
            byArray[13] = 5;
            byArray[14] = 6;
            byArray[15] = 7;
            byte[] key = byArray;
            byte[] byArray2 = new byte[16];
            byArray2[1] = 1;
            byArray2[2] = 2;
            byArray2[3] = 3;
            byArray2[4] = 4;
            byArray2[5] = 5;
            byArray2[6] = 6;
            byArray2[7] = 7;
            byArray2[9] = 1;
            byArray2[10] = 2;
            byArray2[11] = 3;
            byArray2[12] = 4;
            byArray2[13] = 5;
            byArray2[14] = 6;
            byArray2[15] = 7;
            byte[] iv = byArray2;
            byte[] byArray3 = new byte[48];
            byArray3[1] = 1;
            byArray3[2] = 2;
            byArray3[3] = 3;
            byArray3[4] = 4;
            byArray3[5] = 5;
            byArray3[6] = 6;
            byArray3[7] = 7;
            byArray3[9] = 1;
            byArray3[10] = 2;
            byArray3[11] = 3;
            byArray3[12] = 4;
            byArray3[13] = 5;
            byArray3[14] = 6;
            byArray3[15] = 7;
            byArray3[17] = 1;
            byArray3[18] = 2;
            byArray3[19] = 3;
            byArray3[20] = 4;
            byArray3[21] = 5;
            byArray3[22] = 6;
            byArray3[23] = 7;
            byArray3[25] = 1;
            byArray3[26] = 2;
            byArray3[27] = 3;
            byArray3[28] = 4;
            byArray3[29] = 5;
            byArray3[30] = 6;
            byArray3[31] = 7;
            byArray3[33] = 1;
            byArray3[34] = 2;
            byArray3[35] = 3;
            byArray3[36] = 4;
            byArray3[37] = 5;
            byArray3[38] = 6;
            byArray3[39] = 7;
            byArray3[41] = 1;
            byArray3[42] = 2;
            byArray3[43] = 3;
            byArray3[44] = 4;
            byArray3[45] = 5;
            byArray3[46] = 6;
            byArray3[47] = 7;
            byte[] input = byArray3;
            cipher.setIV(iv);
            cipher.init(1, key);
            byte[] ct1 = cipher.doFinal(input, 0, input.length);
            int i = input.length / 2 - 3;
            cipher.init(2, key);
            byte[] ct2 = new byte[ct1.length];
            byte[] t1 = cipher.update(ct1, 0, i);
            byte[] t2 = cipher.doFinal(ct1, i, input.length - i);
            System.arraycopy(t1, 0, ct2, 0, t1.length);
            System.arraycopy(t2, 0, ct2, t1.length, t2.length);
            ok = NIST_Cipher.areEqual(input, ct2);
            if (!ok) {
                throw new RuntimeException("Level-1 API failed");
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

