/*
 * Decompiled with CFR 0.152.
 */
package NIST;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class NIST_Properties {
    static final boolean GLOBAL_DEBUG = true;
    static final String ALGORITHM = "NIST";
    static final double VERSION = 0.1;
    static final String FULL_NAME;
    static final String NAME = "NIST_Properties";
    static final Properties properties;
    private static final String[][] DEFAULT_PROPERTIES;
    static /* synthetic */ Class class$NIST$NIST_Properties;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String value) {
        return properties.getProperty(key, value);
    }

    public static void list(PrintStream out) {
        NIST_Properties.list(new PrintWriter(out, true));
    }

    public static void list(PrintWriter out) {
        out.println("#");
        out.println("# ----- Begin NIST properties -----");
        out.println("#");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = NIST_Properties.getProperty(key);
            out.println(String.valueOf(key) + " = " + value);
        }
        out.println("#");
        out.println("# ----- End NIST properties -----");
    }

    public static Enumeration propertyNames() {
        return properties.propertyNames();
    }

    static boolean isTraceable(String label) {
        String s = NIST_Properties.getProperty("Trace." + label);
        if (s == null) {
            return false;
        }
        return new Boolean(s);
    }

    static int getLevel(String label) {
        String s = NIST_Properties.getProperty("Debug.Level." + label);
        if (s == null && (s = NIST_Properties.getProperty("Debug.Level.*")) == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static PrintWriter getOutput() {
        String name = NIST_Properties.getProperty("Output");
        PrintWriter pw = name != null && name.equals("out") ? new PrintWriter(System.out, true) : new PrintWriter(System.err, true);
        return pw;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        boolean ok;
        FULL_NAME = "NIST ver. " + 0.1;
        properties = new Properties();
        DEFAULT_PROPERTIES = new String[][]{{"Trace.NIST_Algorithm", "false"}, {"Trace.NIST_CBC", "false"}, {"Trace.NIST_ECB", "false"}, {"Trace.NIST_CFB", "false"}, {"Debug.Level.*", "0"}, {"Debug.Level.NIST_Algorithm", "0"}, {"Debug.Level.NIST_CBC", "0"}, {"Debug.Level.NIST_ECB", "0"}, {"Debug.Level.NIST_CFB", "0"}};
        System.err.println(">>> NIST_Properties: Looking for NIST properties");
        String it = "NIST.properties";
        InputStream is = (class$NIST$NIST_Properties != null ? class$NIST$NIST_Properties : (class$NIST$NIST_Properties = NIST_Properties.class$("NIST.NIST_Properties"))).getResourceAsStream(it);
        boolean bl = ok = is != null;
        if (ok) {
            try {
                properties.load(is);
                is.close();
                System.err.println(">>> NIST_Properties: Properties file loaded OK...");
            }
            catch (Exception exception) {
                ok = false;
            }
        }
        if (!ok) {
            System.err.println(">>> NIST_Properties: WARNING: Unable to load \"" + it + "\" from CLASSPATH.");
            System.err.println(">>> NIST_Properties:          Will use default values instead...");
            int n = DEFAULT_PROPERTIES.length;
            int i = 0;
            while (i < n) {
                ((Hashtable)properties).put(DEFAULT_PROPERTIES[i][0], DEFAULT_PROPERTIES[i][1]);
                ++i;
            }
            System.err.println(">>> NIST_Properties: Default properties now set...");
        }
    }
}

