
# -------------------------------------------------------------------
# Jarify a candidate Algorithm classes.
#
# $version: $
# -------------------------------------------------------------------

algo=${ALGO:-$1}
[ -z "${algo}" ] &&
    echo "No algorithm?   Set ALGO or give first argument" &&
    echo "Usage: util/jarit.sh [ALGO]" && exit 1
#!/bin/sh

#
#  Cd to the right place
#
aes_home=${AES_HOME:-.}
[ ! -d ${aes_home}/XXX ] &&
    echo "Not in AES Home, no XXX?   Set AES_HOME or cd to it" && exit 1

[ ! -d ${aes_home}/${algo} ] &&
    echo "No such algorithm ${algo}: directory does not exist: ${aes_home}/${algo}" && exit 1

[ ! -d ${aes_home}/${algo}/classes ] &&
    echo "Algorithm classes not made yet: ${aes_home}/${algo}/classes" && exit 1

cd ${aes_home}/${algo}/classes
pwd

[ ! -f ${algo}/${algo}.properties ] &&
    echo "Missing algorithm's dynamic properties file: ${algo}.properties" &&
    exit 1




AlgoJar=../${algo}.jar

echo jar cvf ${AlgoJar} ${algo}
jar cvf ${AlgoJar} ${algo}
ret=$?

[ ${ret} -ne 0 ] &&
    echo "Jar failed: ${ret}" && exit 1

exit 0
#
#   A quick self-test.
#
echo cd .. '# a quick self test, except this part is untested'
cd ..

CLASSPATH=${CLASSPATH}:${algo}.jar
export CLASSPATH
echo
echo 'CLASSPATH='${CLASSPATH}

echo java ${algo}.${algo}_ECB
java ${algo}.${algo}_ECB
ret=$?

[ ${ret} -ne  0 ] && echo "Self Test Failed: ${ret}"
exit ${ret}
