/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.tool;

import cryptix.asn1.lexer.Lexer;
import cryptix.asn1.node.Start;
import cryptix.asn1.parser.Parser;
import cryptix.asn1.tool.DisplayTree;
import cryptix.asn1.tool.PrintWalker;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PushbackReader;

public class PrintTree {
    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("Usage:");
            System.out.println("  java cryptix.asn1.tool.PrintTree [--gui] filename");
            System.exit(1);
        }
        String string = stringArray.length == 2 ? stringArray[1] : stringArray[0];
        try {
            Lexer lexer = new Lexer(new PushbackReader(new BufferedReader(new FileReader(string)), 1024));
            Parser parser = new Parser(lexer);
            Start start = parser.parse();
            if (stringArray[0].equals("--gui")) {
                DisplayTree displayTree = new DisplayTree();
                start.apply(displayTree);
                displayTree.displayTree();
            } else {
                start.apply(new PrintWalker());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

