/* $Id: EncodingException.java,v 1.1.1.1 2001/02/24 04:59:02 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.io;

/**
 * A subclass of ASNIOException class (checked exception) to denote that a
 * general I/O exception related to encoding-decoding an ASN.1 Element has
 * occured.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class EncodingException extends ASNIOException {

	// Constants and vars
	// .......................................................................

	/**
	 * The distinguished name of the encoder/decoder.
	 */
	private String encoding;

	// Constructor(s)
	// .......................................................................

	/**
	 * Constructs an <tt>EncodingException</tt> with no detail message.
	 *
	 * @param encoding the distinguished name of the encoding.
	 */
	public EncodingException(String encoding) {
		this(encoding, "");
	}

	/**
	 * Constructs an <tt>EncodingException</tt> with the specified detail
	 * message. The error message string <tt>detail</tt> can later be retrieved
	 * by the <tt>getMessage()</tt> method of class <tt>java.lang.Throwable</tt>.
	 *
	 * @param encoding the distinguished name of the encoding.
	 * @param detail the detail message.
	 */
	public EncodingException(String encoding, String detail) {
		super(detail);

		this.encoding = encoding;
	}

	// Instance methods
	// .......................................................................

	/**
	 * Returns the name of the coder/decoder that caused this exception.
	 *
	 * @returns the name of the encoder/decoder that caused this exception.
	 */
	public String getEncoding() {
		return (encoding);
	}
}