/* $Id: IIterativeType.java,v 1.1.1.1 2001/02/24 04:59:04 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import java.util.ListIterator;

/**
 * The (additional) visible method of any ASN.1 compound type: ie. SEQUENCE,
 * SET, SEQUENCE OF and SET OF.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public interface IIterativeType extends IType {

	/**
	 * Returns an iterator over the constituants of a compound type that allows
	 * modification of the contents.
	 *
	 * @return an iterator over the constituants of a compound type.
	 */
	ListIterator iterator();

	/**
	 * Returns the count of elements in the collection contained in a compound
	 * type.
	 *
	 * @return the count of elements in the underlying collection of a compound
	 * type.
	 */
	int size();
}