/* $Id: TeletexString.java,v 1.2 2001/05/24 16:52:49 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;

import org.apache.log4j.Category;

import java.io.EOFException;
import java.io.IOException;

/**
 * The basic implementation of an ASN.1 TeletexString type.<p>
 *
 * @version $Revision: 1.2 $
 * @author  Raif S. Naffah
 */
public class TeletexString extends ASNString implements IType {

	// Constants and vars
	// .......................................................................

	static Category cat = Category.getInstance(TeletexString.class.getName());

	// Constructor(s)
	// .......................................................................

	public TeletexString() {
		super("", new Tag(Tag.T61_STRING));
	}

	public TeletexString(String name) {
		super(name, new Tag(Tag.T61_STRING));
	}

	public TeletexString(String name, Tag tag) {
		super(name, tag);
	}

	public TeletexString(String name, Object value) {
		this(name, new Tag(Tag.T61_STRING), value);
	}

	/**
	 * Constructs a new instance of a TeletexString type, given a designated
	 * Tag and a designated initial value.
	 *
	 * @param name the name of this instance.
	 * @param tag the designated Tag value.
	 * @param value the designated initial value. Allowed types are:
	 * <tt>java.lang.String</tt>, and any subclass of <tt>cryptix.asn1.lang.ASNString</tt>.
	 * @exception ClassCastException if the designated value is not a String.
	 */
	public TeletexString(String name, Tag tag, Object value) {
		super(name, tag);

		value(value);

		if (this.value != null)
			defaultValue(this.value);
	}

	// Class methods
	// .......................................................................

	/**
	 * Returns a new instance of this type with a trivial name and the
	 * designated value.
	 *
	 * @param value a designated initial value for the new instance.
	 * @return a new instance with the designated value.
	 * @exception ClassCastException if the designated value is not appropriate
	 * (see constructor with 3 arguments for suitable types of value).
	 */
	public static TeletexString getInstance(String value) {
		return new TeletexString("", value);
	}

	/**
	 * Returns a new instance of this type with a trivial name and the
	 * designated value.
	 *
	 * @param value a designated initial value for the new instance.
	 * @return a new instance with the designated value.
	 * @exception ClassCastException if the designated value is not appropriate
	 * (see constructor with 3 arguments for suitable types of value).
	 */
	public static TeletexString getInstance(ASNString value) {
		return new TeletexString("", value);
	}

	// Redefinition of methods in superclass Type
	// .......................................................................

	/**
	 * Decodes a TeletexString from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void decode(ASNReader is) throws IOException {
		this.decodeInternal(is, Tag.T61_STRING);
	}

	/**
	 * Encodes a TeletexString to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void encode(ASNWriter os) throws IOException {
		this.encodeInternal(os, Tag.T61_STRING);
	}
}