/* $Id: TestOfBlankOptional.java,v 1.1 2001/05/26 07:10:53 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

/**
 * Regression test for bug #424488.
 *
 * OPTIONAL blank types are not encoded/decoded properly.<p>
 *
 * @version $Revision: 1.1 $
 * @author  Raif S. Naffah
 */
public class TestOfBlankOptional extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

	SeqTypeB seq1;
	SeqTypeC seq2;
	SeqTypeD seq3;
	byte[] data1, data2, data3;
	ASNWriter der;
	ByteArrayOutputStream baos;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfBlankOptional(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfBlankOptional.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testEncodeOptional1() {
      try {
		   makeData1();
   		assertTrue(true);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testDecodeOptional1() {
      try {
         if (data1 == null)
   		   makeData1();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeB seq = new SeqTypeB();

   		der.open(new ByteArrayInputStream(data1));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getB().booleanValue().equals(Boolean.TRUE));
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testEncodeOptional2() {
      try {
		   makeData2();
   		assertTrue(true);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testDecodeOptional2() {
      try {
         if (data2 == null)
   		   makeData2();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeC seq = new SeqTypeC();

   		der.open(new ByteArrayInputStream(data2));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getC().intValue().compareTo(new BigInteger("7")) == 0);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testEncodeOptional3() {
      try {
		   makeData3();
   		assertTrue(true);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testDecodeOptional3() {
      try {
         if (data3 == null)
   		   makeData3();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeD seq = new SeqTypeD();

   		der.open(new ByteArrayInputStream(data3));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getF().intValue().compareTo(new BigInteger("5")) == 0);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	protected void setUp() throws Exception {
	   der = Factory.getEncoder("DER");
	   baos = new ByteArrayOutputStream();

		seq1 = new SeqTypeB("sequence-1");
      seq1.setB(ASNBoolean.getInstance(true));

		seq2 = new SeqTypeC("sequence-2");
      seq2.setC(ASNInteger.getInstance(7));

		seq3 = new SeqTypeD("sequence-3");
      seq3.setD(ASNBoolean.getInstance(true));
      seq3.setF(ASNInteger.getInstance(5));
	}

	private void makeData1() throws Exception {
      baos.reset();
      der.open(baos);
      seq1.encode(der);
      der.close();
      data1 = baos.toByteArray();
   }

	private void makeData2() throws Exception {
      baos.reset();
      der.open(baos);
      seq2.encode(der);
      der.close();
      data2 = baos.toByteArray();
   }

	private void makeData3() throws Exception {
      baos.reset();
      der.open(baos);
      seq3.encode(der);
      der.close();
      data3 = baos.toByteArray();
   }
}