/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import java.io.Serializable;

public class Tag
implements Serializable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 64;
    public static final int CONTEXT = 128;
    public static final int PRIVATE = 192;
    public static final int BOOLEAN = 1;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int REAL = 9;
    public static final int SEQUENCE = 16;
    public static final int SEQUENCE_OF = 16;
    public static final int SET = 17;
    public static final int SET_OF = 17;
    public static final int NUMERIC_STRING = 18;
    public static final int PRINTABLE_STRING = 19;
    public static final int T61_STRING = 20;
    public static final int VIDEOTEX_STRING = 21;
    public static final int IA5_STRING = 22;
    public static final int GRAPHIC_STRING = 25;
    public static final int ISO646_STRING = 26;
    public static final int GENERAL_STRING = 27;
    public static final int UNIVERSAL_STRING = 28;
    public static final int BMP_STRING = 30;
    public static final int UTC_TIME = 23;
    public static final int GENERALIZED_TIME = 24;
    int clazz;
    int value;
    boolean explicit;
    boolean constructed;

    public Object clone() {
        return new Tag(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)object;
        if (this.getClazz() != tag.getClazz()) {
            return false;
        }
        return this.getValue() == tag.getValue();
    }

    public int getClazz() {
        return this.clazz;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public boolean isUniversal() {
        return this.clazz == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<Tag class=\"");
        switch (this.clazz) {
            case 0: {
                stringBuffer.append("UNIVERSAL");
                break;
            }
            case 64: {
                stringBuffer.append("APPLICATION");
                break;
            }
            case 128: {
                stringBuffer.append("CONTEXT");
                break;
            }
            case 192: {
                stringBuffer.append("PRIVATE");
                break;
            }
            default: {
                stringBuffer.append(this.clazz);
            }
        }
        stringBuffer.append("\" value=\"");
        if (this.clazz == 128) {
            stringBuffer.append(this.value);
        } else {
            switch (this.value) {
                case 1: {
                    stringBuffer.append("BOOLEAN");
                    break;
                }
                case 2: {
                    stringBuffer.append("INTEGER");
                    break;
                }
                case 3: {
                    stringBuffer.append("BIT STRING");
                    break;
                }
                case 4: {
                    stringBuffer.append("OCTET STRING");
                    break;
                }
                case 5: {
                    stringBuffer.append("NULL");
                    break;
                }
                case 6: {
                    stringBuffer.append("OBJECT IDENTIFIER");
                    break;
                }
                case 16: {
                    stringBuffer.append("SEQUENCE [OF]");
                    break;
                }
                case 17: {
                    stringBuffer.append("SET [OF]");
                    break;
                }
                case 18: {
                    stringBuffer.append("NumericString");
                    break;
                }
                case 19: {
                    stringBuffer.append("PrintableString");
                    break;
                }
                case 20: {
                    stringBuffer.append("TeletexString");
                    break;
                }
                case 21: {
                    stringBuffer.append("VideotexString");
                    break;
                }
                case 22: {
                    stringBuffer.append("IA5String");
                    break;
                }
                case 25: {
                    stringBuffer.append("GraphicString");
                    break;
                }
                case 26: {
                    stringBuffer.append("VisibleString");
                    break;
                }
                case 27: {
                    stringBuffer.append("GeneralString");
                    break;
                }
                case 28: {
                    stringBuffer.append("UniversalString");
                    break;
                }
                case 30: {
                    stringBuffer.append("BMPString");
                    break;
                }
                case 23: {
                    stringBuffer.append("UTCTime");
                    break;
                }
                case 24: {
                    stringBuffer.append("GeneralizedTime");
                    break;
                }
                default: {
                    stringBuffer.append(this.value);
                }
            }
        }
        stringBuffer.append("\" explicit=\"").append(String.valueOf(this.explicit));
        stringBuffer.append("\" constructed=\"").append(String.valueOf(this.constructed)).append("\" />");
        return stringBuffer.toString();
    }

    public Tag(int n, int n2, boolean bl, boolean bl2) {
        this.clazz = n;
        this.value = n2;
        this.explicit = bl;
        this.constructed = bl2;
    }

    public Tag(int n, int n2, boolean bl) {
        this(n, n2, bl, false);
    }

    public Tag(int n, int n2) {
        this(n, n2, true, false);
    }

    public Tag(int n, boolean bl) {
        this(0, n, bl, false);
    }

    public Tag(int n) {
        this(0, n, true, false);
    }

    private Tag(Tag tag) {
        this(tag.clazz, tag.value, tag.explicit, tag.constructed);
    }
}

