/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.tool;

import cryptix.asn1.analysis.DepthFirstAdapter;
import cryptix.asn1.lang.NodeInfo;
import cryptix.asn1.node.AAccessType;
import cryptix.asn1.node.AAnyBuiltInType;
import cryptix.asn1.node.AAppClazz;
import cryptix.asn1.node.ABitBuiltInType;
import cryptix.asn1.node.ABmpBuiltInType;
import cryptix.asn1.node.ABooleanBuiltInType;
import cryptix.asn1.node.AChoiceBuiltInType;
import cryptix.asn1.node.ADefaultElementTypeSuf;
import cryptix.asn1.node.AExplicitTagDefault;
import cryptix.asn1.node.AGeneralBuiltInType;
import cryptix.asn1.node.AGmtBuiltInType;
import cryptix.asn1.node.AGraphicBuiltInType;
import cryptix.asn1.node.AIa5BuiltInType;
import cryptix.asn1.node.AIntegerBuiltInType;
import cryptix.asn1.node.ALowerAuxNamedNum;
import cryptix.asn1.node.ALowerNamedType;
import cryptix.asn1.node.ANamedElementType;
import cryptix.asn1.node.ANamedNumber;
import cryptix.asn1.node.ANegativeAuxNamedNum;
import cryptix.asn1.node.ANullType;
import cryptix.asn1.node.ANumericBuiltInType;
import cryptix.asn1.node.ANumericClassNumber;
import cryptix.asn1.node.AOctetBuiltInType;
import cryptix.asn1.node.AOidBuiltInType;
import cryptix.asn1.node.AOptionalElementTypeSuf;
import cryptix.asn1.node.APositiveAuxNamedNum;
import cryptix.asn1.node.APrintableBuiltInType;
import cryptix.asn1.node.APrivateClazz;
import cryptix.asn1.node.ASequenceAuxType;
import cryptix.asn1.node.ASequenceOfAuxType;
import cryptix.asn1.node.ASetAuxType;
import cryptix.asn1.node.ASetOfAuxType;
import cryptix.asn1.node.ASizeTypeSuf;
import cryptix.asn1.node.ATaggedAuxType;
import cryptix.asn1.node.ATeletexBuiltInType;
import cryptix.asn1.node.AUniversalBuiltInType;
import cryptix.asn1.node.AUniversalClazz;
import cryptix.asn1.node.AUpperAuxNamedNum;
import cryptix.asn1.node.AUpperType;
import cryptix.asn1.node.AUtcBuiltInType;
import cryptix.asn1.node.AVideotexBuiltInType;
import cryptix.asn1.node.AVisibleBuiltInType;
import cryptix.asn1.node.Node;
import cryptix.asn1.node.PAccessType;
import cryptix.asn1.node.PAuxNamedNum;
import cryptix.asn1.node.PClassNumber;
import cryptix.asn1.node.PClazz;
import cryptix.asn1.node.PTagDefault;
import cryptix.asn1.node.PTypeSuf;
import cryptix.asn1.node.PValue;
import cryptix.asn1.tool.Interpreter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Category;

public class Generator
extends DepthFirstAdapter {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$tool$Generator != null ? class$Lcryptix$asn1$tool$Generator : (class$Lcryptix$asn1$tool$Generator = Generator.class$("cryptix.asn1.tool.Generator"))).getName());
    private static final int NOT_GENERATING = 0;
    private static final int GENERATING = 1;
    private static final int REFERENCE_ONLY = 2;
    private PrintWriter pw;
    Interpreter ast;
    int indent = 0;
    int state;
    String moduleName;
    String pkgName;
    String className;
    LinkedList data;
    String lower;
    String type;
    String tag;
    private static /* synthetic */ Class class$Lcryptix$asn1$tool$Generator;

    public static final String toJava(String string) {
        cat.debug((Object)("==> toJava(" + String.valueOf(string) + ")"));
        if (string != null) {
            int n = string.indexOf("--");
            while (n > -1) {
                string = string.substring(0, n) + string.substring(n + 1);
                n = string.indexOf("--");
            }
            n = string.indexOf("-");
            while (n > -1) {
                string = string.substring(0, n) + Generator.toProper(string.substring(n + 1));
                n = string.indexOf("-");
            }
        }
        cat.debug((Object)("<== toJava() --> " + String.valueOf(string)));
        return string;
    }

    private static final String toProper(String string) {
        if (string.equals("")) {
            return string;
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public void generate(File file, Map map) throws IOException {
        Map map2 = this.ast.getModules();
        Set set = map2.keySet();
        Object[] objectArray = set.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.generate(file, (String)objectArray[n2], map);
            ++n2;
        }
    }

    public void generate(File file, String string, Map map) throws IOException {
        Map map2 = this.ast.getComponents(string);
        Set set = map2.keySet();
        cat.debug((Object)("Types defined in module " + String.valueOf(string) + ":\n" + String.valueOf(map2)));
        Object[] objectArray = set.toArray();
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            String string2 = (String)objectArray[n];
            if (this.isPermissibleType(string2)) {
                Node node = (Node)map2.get(string2);
                this.generate(file, string, map, Generator.toJava(string2), node);
            }
            ++n;
        }
        this.generateModule(file, string, map);
    }

    public void generate(File file, String string, String string2, Map map) throws IOException {
        if (!this.isPermissibleType(string2)) {
            throw new IllegalArgumentException();
        }
        Node node = this.ast.getComponent(string, string2);
        this.generate(file, string, map, string2, node);
    }

    public void defaultIn(Node node) {
        ++this.indent;
        String string = "";
        int n = 0;
        while (n < this.indent) {
            string = string + "   ";
            ++n;
        }
        cat.debug((Object)(string + "--> " + node.getClass().getName()));
    }

    public void defaultOut(Node node) {
        String string = "";
        int n = 0;
        while (n < this.indent) {
            string = string + "   ";
            ++n;
        }
        cat.debug((Object)(string + "<-- " + node.getClass().getName() + ": " + node));
        --this.indent;
    }

    public void inAIntegerBuiltInType(AIntegerBuiltInType aIntegerBuiltInType) {
        this.defaultIn(aIntegerBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "INTEGER");
                this.state = 2;
                break;
            }
        }
    }

    public void outAIntegerBuiltInType(AIntegerBuiltInType aIntegerBuiltInType) {
        this.defaultOut(aIntegerBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "INTEGER";
                break;
            }
        }
    }

    public void outANamedNumber(ANamedNumber aNamedNumber) {
        this.defaultOut(aNamedNumber);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                String string = aNamedNumber.getLower().getText().trim();
                PAuxNamedNum pAuxNamedNum = aNamedNumber.getAuxNamedNum();
                StringBuffer stringBuffer = new StringBuffer("new ASNInteger(");
                stringBuffer.append("\"").append(this.className).append(".").append(string).append("\", ");
                if (pAuxNamedNum instanceof APositiveAuxNamedNum) {
                    APositiveAuxNamedNum aPositiveAuxNamedNum = (APositiveAuxNamedNum)pAuxNamedNum;
                    stringBuffer.append("\"").append(aPositiveAuxNamedNum.getNumber().getText().trim()).append("\"");
                } else if (pAuxNamedNum instanceof ANegativeAuxNamedNum) {
                    ANegativeAuxNamedNum aNegativeAuxNamedNum = (ANegativeAuxNamedNum)pAuxNamedNum;
                    stringBuffer.append("\"-").append(aNegativeAuxNamedNum.getNumber().getText().trim()).append("\"");
                } else if (pAuxNamedNum instanceof ALowerAuxNamedNum) {
                    ALowerAuxNamedNum aLowerAuxNamedNum = (ALowerAuxNamedNum)pAuxNamedNum;
                    stringBuffer.append(aLowerAuxNamedNum.getLower().getText().trim());
                } else if (pAuxNamedNum instanceof AUpperAuxNamedNum) {
                    AUpperAuxNamedNum aUpperAuxNamedNum = (AUpperAuxNamedNum)pAuxNamedNum;
                    stringBuffer.append(aUpperAuxNamedNum.getUpper().getText().trim()).append(".").append(aUpperAuxNamedNum.getLower().getText().trim());
                }
                stringBuffer.append(")");
                this.outAttribute(this.className, string, stringBuffer.toString());
                break;
            }
        }
    }

    public void outANullType(ANullType aNullType) {
        this.defaultOut(aNullType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "NULL";
                break;
            }
        }
    }

    public void inABooleanBuiltInType(ABooleanBuiltInType aBooleanBuiltInType) {
        this.defaultIn(aBooleanBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "BOOLEAN");
                this.state = 2;
                break;
            }
        }
    }

    public void outABooleanBuiltInType(ABooleanBuiltInType aBooleanBuiltInType) {
        this.defaultOut(aBooleanBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "BOOLEAN";
                break;
            }
        }
    }

    public void inABitBuiltInType(ABitBuiltInType aBitBuiltInType) {
        this.defaultIn(aBitBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "BIT_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outABitBuiltInType(ABitBuiltInType aBitBuiltInType) {
        this.defaultOut(aBitBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "BIT_STRING";
                break;
            }
        }
    }

    public void inAOctetBuiltInType(AOctetBuiltInType aOctetBuiltInType) {
        this.defaultIn(aOctetBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "OCTET_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAOctetBuiltInType(AOctetBuiltInType aOctetBuiltInType) {
        this.defaultOut(aOctetBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "OCTET_STRING";
                break;
            }
        }
    }

    public void inAAnyBuiltInType(AAnyBuiltInType aAnyBuiltInType) {
        this.defaultIn(aAnyBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "ANY");
                this.state = 2;
                break;
            }
        }
    }

    public void outAAnyBuiltInType(AAnyBuiltInType aAnyBuiltInType) {
        this.defaultOut(aAnyBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "ANY";
                break;
            }
        }
    }

    public void inAOidBuiltInType(AOidBuiltInType aOidBuiltInType) {
        this.defaultIn(aOidBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "OBJECT_IDENTIFIER");
                this.state = 2;
                break;
            }
        }
    }

    public void outAOidBuiltInType(AOidBuiltInType aOidBuiltInType) {
        this.defaultOut(aOidBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "OBJECT_IDENTIFIER";
                break;
            }
        }
    }

    public void inAPrintableBuiltInType(APrintableBuiltInType aPrintableBuiltInType) {
        this.defaultIn(aPrintableBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "PRINTABLE_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAPrintableBuiltInType(APrintableBuiltInType aPrintableBuiltInType) {
        this.defaultOut(aPrintableBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "PRINTABLE_STRING";
                break;
            }
        }
    }

    public void inANumericBuiltInType(ANumericBuiltInType aNumericBuiltInType) {
        this.defaultIn(aNumericBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "NUMERIC_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outANumericBuiltInType(ANumericBuiltInType aNumericBuiltInType) {
        this.defaultOut(aNumericBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "NUMERIC_STRING";
                break;
            }
        }
    }

    public void inATeletexBuiltInType(ATeletexBuiltInType aTeletexBuiltInType) {
        this.defaultIn(aTeletexBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "T61_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outATeletexBuiltInType(ATeletexBuiltInType aTeletexBuiltInType) {
        this.defaultOut(aTeletexBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "T61_STRING";
                break;
            }
        }
    }

    public void inAVideotexBuiltInType(AVideotexBuiltInType aVideotexBuiltInType) {
        this.defaultIn(aVideotexBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "VIDEOTEX_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAVideotexBuiltInType(AVideotexBuiltInType aVideotexBuiltInType) {
        this.defaultOut(aVideotexBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "VIDEOTEX_STRING";
                break;
            }
        }
    }

    public void inAVisibleBuiltInType(AVisibleBuiltInType aVisibleBuiltInType) {
        this.defaultIn(aVisibleBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "ISO646_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAVisibleBuiltInType(AVisibleBuiltInType aVisibleBuiltInType) {
        this.defaultOut(aVisibleBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "ISO646_STRING";
                break;
            }
        }
    }

    public void inAIa5BuiltInType(AIa5BuiltInType aIa5BuiltInType) {
        this.defaultIn(aIa5BuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "IA5_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAIa5BuiltInType(AIa5BuiltInType aIa5BuiltInType) {
        this.defaultOut(aIa5BuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "IA5_STRING";
                break;
            }
        }
    }

    public void inAGraphicBuiltInType(AGraphicBuiltInType aGraphicBuiltInType) {
        this.defaultIn(aGraphicBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "GRAPHIC_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAGraphicBuiltInType(AGraphicBuiltInType aGraphicBuiltInType) {
        this.defaultOut(aGraphicBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "GRAPHIC_STRING";
                break;
            }
        }
    }

    public void inAGeneralBuiltInType(AGeneralBuiltInType aGeneralBuiltInType) {
        this.defaultIn(aGeneralBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "GENERAL_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAGeneralBuiltInType(AGeneralBuiltInType aGeneralBuiltInType) {
        this.defaultOut(aGeneralBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "GENERAL_STRING";
                break;
            }
        }
    }

    public void inAUniversalBuiltInType(AUniversalBuiltInType aUniversalBuiltInType) {
        this.defaultIn(aUniversalBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "UNIVERSAL_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outAUniversalBuiltInType(AUniversalBuiltInType aUniversalBuiltInType) {
        this.defaultOut(aUniversalBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "UNIVERSAL_STRING";
                break;
            }
        }
    }

    public void inABmpBuiltInType(ABmpBuiltInType aBmpBuiltInType) {
        this.defaultIn(aBmpBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "BMP_STRING");
                this.state = 2;
                break;
            }
        }
    }

    public void outABmpBuiltInType(ABmpBuiltInType aBmpBuiltInType) {
        this.defaultOut(aBmpBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "BMP_STRING";
                break;
            }
        }
    }

    public void inAGmtBuiltInType(AGmtBuiltInType aGmtBuiltInType) {
        this.defaultIn(aGmtBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "GENERALIZED_TIME");
                this.state = 2;
                break;
            }
        }
    }

    public void outAGmtBuiltInType(AGmtBuiltInType aGmtBuiltInType) {
        this.defaultOut(aGmtBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "GENERALIZED_TIME";
                break;
            }
        }
    }

    public void inAUtcBuiltInType(AUtcBuiltInType aUtcBuiltInType) {
        this.defaultIn(aUtcBuiltInType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "UTC_TIME");
                this.state = 2;
                break;
            }
        }
    }

    public void outAUtcBuiltInType(AUtcBuiltInType aUtcBuiltInType) {
        this.defaultOut(aUtcBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.type = "UTC_TIME";
                break;
            }
        }
    }

    public void inAChoiceBuiltInType(AChoiceBuiltInType aChoiceBuiltInType) {
        this.defaultIn(aChoiceBuiltInType);
        switch (this.state) {
            case 1: {
                this.data.clear();
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "CHOICE");
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outAChoiceBuiltInType(AChoiceBuiltInType aChoiceBuiltInType) {
        this.defaultOut(aChoiceBuiltInType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                if (this.data.isEmpty()) {
                    throw new RuntimeException("CHOICE with no alternatives");
                }
                this.generateChoice(this.data);
                this.type = "CHOICE";
                this.state = 0;
                break;
            }
        }
    }

    public void inATaggedAuxType(ATaggedAuxType aTaggedAuxType) {
        StringBuffer stringBuffer = new StringBuffer("new Tag(");
        PClazz pClazz = aTaggedAuxType.getClazz();
        PClassNumber pClassNumber = aTaggedAuxType.getClassNumber();
        PTagDefault pTagDefault = aTaggedAuxType.getTagDefault();
        if (pClazz == null) {
            stringBuffer.append("Tag.CONTEXT, ");
        } else if (pClazz instanceof AUniversalClazz) {
            stringBuffer.append("Tag.UNIVERSAL, ");
        } else if (pClazz instanceof AAppClazz) {
            stringBuffer.append("Tag.APPLICATION, ");
        } else if (pClazz instanceof APrivateClazz) {
            stringBuffer.append("Tag.PRIVATE, ");
        }
        if (!(pClassNumber instanceof ANumericClassNumber)) {
            throw new RuntimeException("Dont know how to handle this yet");
        }
        stringBuffer.append(((ANumericClassNumber)pClassNumber).getNumber().getText().trim());
        if (pTagDefault == null) {
            stringBuffer.append(", Module.EXPLICIT_TAGGING");
        } else if (pTagDefault instanceof AExplicitTagDefault) {
            stringBuffer.append(", true");
        } else {
            stringBuffer.append(", false");
        }
        this.tag = stringBuffer.append(")").toString();
    }

    public void inASetOfAuxType(ASetOfAuxType aSetOfAuxType) {
        this.defaultIn(aSetOfAuxType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "SET_OF");
                this.data.clear();
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outASetOfAuxType(ASetOfAuxType aSetOfAuxType) {
        this.defaultOut(aSetOfAuxType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                if (this.data.isEmpty()) {
                    this.generateCompound(this.type);
                } else {
                    this.generateCompound(this.data);
                }
                this.type = "SET_OF";
                this.state = 0;
                break;
            }
        }
    }

    public void inASetAuxType(ASetAuxType aSetAuxType) {
        this.defaultIn(aSetAuxType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                String string = "SET";
                PTypeSuf pTypeSuf = aSetAuxType.getTypeSuf();
                if (pTypeSuf != null && pTypeSuf instanceof ASizeTypeSuf) {
                    string = string + "_OF";
                }
                this.outBuiltInClass(bl, this.className, string);
                this.data.clear();
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outASetAuxType(ASetAuxType aSetAuxType) {
        this.defaultOut(aSetAuxType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                String string = "SET";
                PTypeSuf pTypeSuf = aSetAuxType.getTypeSuf();
                if (pTypeSuf != null && pTypeSuf instanceof ASizeTypeSuf) {
                    string = string + "_OF";
                }
                if (this.data.isEmpty()) {
                    this.generateCompound(this.type);
                } else {
                    this.generateCompound(this.data);
                }
                this.type = string;
                this.state = 0;
                break;
            }
        }
    }

    public void inASequenceOfAuxType(ASequenceOfAuxType aSequenceOfAuxType) {
        this.defaultIn(aSequenceOfAuxType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outBuiltInClass(bl, this.className, "SEQUENCE_OF");
                this.data.clear();
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outASequenceOfAuxType(ASequenceOfAuxType aSequenceOfAuxType) {
        this.defaultOut(aSequenceOfAuxType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                if (this.data.isEmpty()) {
                    this.generateCompound(this.type);
                } else {
                    this.generateCompound(this.data);
                }
                this.type = "SEQUENCE_OF";
                this.state = 0;
                break;
            }
        }
    }

    public void inASequenceAuxType(ASequenceAuxType aSequenceAuxType) {
        this.defaultIn(aSequenceAuxType);
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                PTypeSuf pTypeSuf = aSequenceAuxType.getTypeSuf();
                String string = "SEQUENCE";
                if (pTypeSuf != null && pTypeSuf instanceof ASizeTypeSuf) {
                    string = string + "_OF";
                }
                this.outBuiltInClass(bl, this.className, string);
                this.data.clear();
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outASequenceAuxType(ASequenceAuxType aSequenceAuxType) {
        this.defaultOut(aSequenceAuxType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                String string = "SEQUENCE";
                PTypeSuf pTypeSuf = aSequenceAuxType.getTypeSuf();
                if (pTypeSuf != null && pTypeSuf instanceof ASizeTypeSuf) {
                    string = string + "_OF";
                }
                if (this.data.isEmpty()) {
                    this.generateCompound(this.type);
                } else {
                    this.generateCompound(this.data);
                }
                this.type = string;
                this.state = 0;
                break;
            }
        }
    }

    public void inANamedElementType(ANamedElementType aNamedElementType) {
        this.defaultIn(aNamedElementType);
        this.lower = null;
        this.type = null;
        this.tag = null;
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outANamedElementType(ANamedElementType aNamedElementType) {
        this.defaultOut(aNamedElementType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    NodeInfo nodeInfo = (NodeInfo)this.data.getLast();
                    if (nodeInfo.getElementName().equals(this.lower)) {
                        this.data.removeLast();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                this.data.add(new NodeInfo(this.lower, this.type, this.tag, aNamedElementType.getElementTypeSuf()));
                break;
            }
        }
    }

    public void outAUpperType(AUpperType aUpperType) {
        this.defaultOut(aUpperType);
        this.type = aUpperType.getUpper().getText().trim();
        PAccessType pAccessType = aUpperType.getAccessType();
        if (pAccessType != null) {
            this.type = this.type + "." + ((AAccessType)pAccessType).getUpper().getText().trim();
        }
        switch (this.state) {
            case 1: {
                boolean bl = this.ast.isPublic(this.moduleName, this.className);
                this.outClass(bl, this.className, this.type);
                this.outUpperConstructors(this.className, this.type);
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void outALowerNamedType(ALowerNamedType aLowerNamedType) {
        this.defaultOut(aLowerNamedType);
        switch (this.state) {
            case 1: {
                break;
            }
            case 2: {
                this.lower = aLowerNamedType.getLower().getText().trim();
                this.data.add(new NodeInfo(this.lower, this.type, this.tag, null));
                break;
            }
        }
    }

    private void activate(PrintWriter printWriter) {
        if (this.pw != null) {
            throw new IllegalStateException();
        }
        this.pw = printWriter;
    }

    private void passivate() {
        if (this.pw != null) {
            this.pw.close();
        }
        this.pw = null;
    }

    private void outBeginClass(String string) {
        cat.info((Object)("==> outBeginClass(" + String.valueOf(string) + ")"));
        this.out("package " + string + "; // machine generated code. DO NOT EDIT");
        this.out();
        this.out("import cryptix.asn1.lang.*;");
        this.out();
        cat.info((Object)"<== outBeginClass()");
    }

    private void outBuiltInClass(boolean bl, String string, String string2) {
        cat.info((Object)("==> outBuiltInClass(" + String.valueOf(bl) + ", " + String.valueOf(string) + ", " + String.valueOf(string2) + ")"));
        this.outClass(bl, string, string2);
        this.outConstructors(string, string2);
        cat.info((Object)"<== outBuiltInClass()");
    }

    private void outClass(boolean bl, String string, String string2) {
        cat.info((Object)("==> outClass(" + String.valueOf(bl) + ", " + String.valueOf(string) + ", " + String.valueOf(string2) + ")"));
        String string3 = this.superclassFromType(string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("public ");
        }
        stringBuffer.append("class ").append(string).append(" extends ").append(string3).append(" {");
        this.out(stringBuffer.toString());
        this.out();
        cat.info((Object)"<== outClass()");
    }

    private void outEndClass() {
        cat.info((Object)"==> outEndClass()");
        this.out("}");
        this.out();
        this.out("// Generated by the cryptix ASN.1 kit on " + String.valueOf(new Date()));
        cat.info((Object)"<== outEndClass()");
    }

    private void outConstructors(String string, String string2) {
        cat.info((Object)("==> outConstructors(" + String.valueOf(string) + ", " + String.valueOf(string2) + ")"));
        cat.info((Object)("    tag: " + String.valueOf(this.tag)));
        String string3 = this.superclassFromType(string2);
        this.out("   // Constructor(s)");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a blank Name.");
        this.out("    */");
        this.out("   public " + string + "() {");
        if (string2.equals("CHOICE") || string2.equals("ANY")) {
            this.out("      super(\"\", null);");
        } else if (this.tag != null) {
            this.out("      super(\"\", " + this.tag + ");");
        } else {
            this.out("      super(\"\", new Tag(Tag." + string2 + "));");
        }
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    */");
        this.out("   public " + string + "(String name) {");
        if (string2.equals("CHOICE") || string2.equals("ANY")) {
            this.out("      super(name, null);");
        } else if (this.tag != null) {
            this.out("      super(name, " + this.tag + ");");
        } else {
            this.out("      super(name, new Tag(Tag." + string2 + "));");
        }
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name and Tag.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param tag the designated tag for this new instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, Tag tag) {");
        this.out("      super(name, tag);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a trivial Name and an");
        this.out("    * initial value.");
        this.out("    *");
        this.out("    * @param value the initial value of this instance.");
        this.out("    */");
        this.out("   public " + string + "(" + string3 + " value) {");
        this.out("      this(\"\", value);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name and an");
        this.out("    * initial value.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param value the initial value of this instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, " + string3 + " value) {");
        if (string2.equals("CHOICE") || string2.equals("ANY")) {
            this.out("      this(name, null, value);");
        } else if (this.tag != null) {
            this.out("      this(name, " + this.tag + ", value);");
        } else {
            this.out("      this(name, new Tag(Tag." + string2 + "), value);");
        }
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type given its Name, Tag and initial");
        this.out("    * value.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param tag the specific tag for this instance.");
        this.out("    * @param value the initial value for this instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, Tag tag, " + string3 + " value) {");
        this.out("      super(name, tag, value == null ? null : value.value());");
        this.out("   }");
        this.out();
        this.outBeginAttributes();
        cat.info((Object)"<== outConstructors()");
    }

    private void outUpperConstructors(String string, String string2) {
        cat.info((Object)("==> outUpperConstructors(" + String.valueOf(string) + ", " + String.valueOf(string2) + ")"));
        String string3 = this.superclassFromType(string2);
        this.out("   // Constructor(s)");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a blank Name.");
        this.out("    */");
        this.out("   public " + string + "() {");
        this.out("      super();");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    */");
        this.out("   public " + string + "(String name) {");
        this.out("      super(name);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name and Tag.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param tag the designated tag for this new instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, Tag tag) {");
        this.out("      super(name, tag);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a trivial Name and an ");
        this.out("    * initial value.");
        this.out("    *");
        this.out("    * @param value the initial value of this instance.");
        this.out("    */");
        this.out("   public " + string + "(" + string3 + " value) {");
        this.out("      super(value);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type with a designated Name and an ");
        this.out("    * initial value.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param value the initial value of this instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, " + string3 + " value) {");
        this.out("      super(name, value);");
        this.out("   }");
        this.out();
        this.out("   /**");
        this.out("    * Constructs a new instance of this type given its Name, Tag and initial");
        this.out("    * values.");
        this.out("    *");
        this.out("    * @param name the designated Name for this new instance.");
        this.out("    * @param tag the specific tag for this instance.");
        this.out("    * @param value the initial value for this instance.");
        this.out("    */");
        this.out("   public " + string + "(String name, Tag tag, " + string3 + " value) {");
        this.out("      super(name, tag, value);");
        this.out("   }");
        this.out();
        this.outBeginAttributes();
        cat.info((Object)"<== outUpperConstructors()");
    }

    private void outBeginAttributes() {
        cat.info((Object)"==> outBeginAttributes()");
        this.out("   // Constants and variables");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        cat.info((Object)"<== outBeginAttributes()");
    }

    private void outAttribute(String string, String string2, String string3) {
        cat.info((Object)("==> outAttribute(" + String.valueOf(string) + ", " + String.valueOf(string2) + ", " + String.valueOf(string3) + ")"));
        StringBuffer stringBuffer = new StringBuffer("   public static final ");
        stringBuffer.append(string).append(" ").append(string2).append(" = new ").append(string).append("(").append("\"").append(string2).append("\", ").append(string3).append(");");
        this.out(stringBuffer.toString());
        cat.info((Object)"<== outAttribute()");
    }

    private void generateChoice(LinkedList linkedList) {
        cat.info((Object)"==> generateChoice()");
        this.generateCompound(linkedList);
        this.out("   // CHOICE-specific convenience methods");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NodeInfo nodeInfo = (NodeInfo)iterator.next();
            String string = Generator.toJava(nodeInfo.getElementName());
            String string2 = nodeInfo.getElementType();
            String string3 = this.superclassFromType(string2);
            String string4 = this.properFromLower(string);
            this.out("   /**");
            this.out("    * Returns true iff this CHOICE instance has been decoded, and its (only)");
            this.out("    * concrete alternative is the designated one. False otherwise.");
            this.out("    *");
            this.out("    * @return true iff this CHOICE instance has been decoded, and its (only)");
            this.out("    * concrete alternative is the designated one. False otherwise.");
            this.out("    */");
            this.out("   public boolean is" + string4 + "() {");
            this.out("      return !get" + string4 + "().isBlank();");
            this.out("   }");
            ++n;
        }
        cat.info((Object)"<== generateChoice()");
    }

    private void generateCompound(String string) {
        cat.info((Object)("==> generateCompound(" + String.valueOf(string) + ")"));
        LinkedList<NodeInfo> linkedList = new LinkedList<NodeInfo>();
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        linkedList.add(new NodeInfo(string2, string, null, null));
        this.generateCompound(linkedList);
        cat.info((Object)"<== generateCompound()");
    }

    private void generateCompound(LinkedList linkedList) {
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        cat.info((Object)"==> generateCompound(LinkedList)");
        this.out();
        this.out("   // Over-loaded implementation of methods defined in superclass");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   protected void initInternal() {");
        this.out("      super.initInternal();");
        this.out();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Node node;
            NodeInfo nodeInfo = (NodeInfo)iterator.next();
            object = nodeInfo.getElementName();
            string4 = Generator.toJava((String)object);
            string3 = nodeInfo.getElementType();
            string2 = this.superclassFromType(string3);
            string = nodeInfo.getTagValue();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("      IType ").append(string4).append(" = new ").append(string2).append("(\"").append((String)object).append("\"");
            if (string != null) {
                stringBuffer.append(", ").append(string);
            }
            if ((node = nodeInfo.getTypeSpecs()) != null && node instanceof ADefaultElementTypeSuf) {
                PValue pValue = ((ADefaultElementTypeSuf)node).getValue();
                String string5 = String.valueOf(pValue).trim();
                stringBuffer.append(", ").append(string2).append(".").append(string5);
            }
            stringBuffer.append(");");
            this.out(stringBuffer.toString());
            if (node != null && node instanceof AOptionalElementTypeSuf) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("      ").append(string4).append(".optional(true);");
                this.out(stringBuffer.toString());
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("      components.add(").append(string4).append(");");
            this.out(stringBuffer.toString());
        }
        this.out("   }");
        this.out();
        this.out("   // Accessor methods");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        int n = 0;
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (NodeInfo)iterator.next();
            string4 = ((NodeInfo)object).getElementName();
            string3 = ((NodeInfo)object).getElementType();
            string2 = this.superclassFromType(string3);
            string = Generator.toJava(this.properFromLower(string4));
            this.out("   public " + string2 + " get" + string + "() {");
            this.out("      return (" + string2 + ") components.get(" + n + ");");
            this.out("   }");
            this.out();
            this.out("   public void set" + string + "(" + string2 + " obj) {");
            this.out("      " + string2 + " it = get" + string + "();");
            this.out("      it.value(obj.value());");
            this.out("      components.set(" + n + ", it);");
            this.out("   }");
            this.out();
            ++n;
        }
        cat.info((Object)"<== generateCompound()");
    }

    private void generateModule(File file, String string, Map map) throws IOException {
        File file2 = this.setupVars(file, string, map, "Module");
        this.activate(new PrintWriter(new FileWriter(file2)));
        this.outBeginClass(this.pkgName);
        this.out("public final class Module {");
        this.out();
        this.out("   // Constants and variables");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /** If module has explicit tagging (true) or not (false). */");
        this.out("   public static final boolean EXPLICIT_TAGGING = " + String.valueOf(!this.ast.getImplicitTagging(string)) + ";");
        this.out();
        this.out("   /** The class Singleton. */");
        this.out("   private static Module singleton = null;");
        this.out();
        this.out("   /**");
        this.out("    * The Map containing the name and string representations of OIDs defined.");
        this.out("    * in this ASN.1 module.");
        this.out("    */");
        this.out("   private static java.util.Map map;");
        this.out();
        this.out("   // Constructor(s)");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /** Trivial private constructor to enforce Singleton pattern. */");
        this.out("   private Module() {");
        this.out("      super();");
        this.out();
        this.out("      map = new java.util.HashMap();");
        Map map2 = this.ast.getOIDs(string);
        Set set = map2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.out("      map.put(\"" + string2 + "\", \"" + (String)map2.get(string2) + "\");");
        }
        this.out("   }");
        this.out();
        this.out("   // Class methods");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /** @return the Singleton instance. */");
        this.out("   public static synchronized Module instance() {");
        this.out("      if (singleton == null)");
        this.out("         singleton = new Module();");
        this.out();
        this.out("      return singleton;");
        this.out("   }");
        this.out();
        this.out("   // Instance methods");
        this.out("   // -------------------------------------------------------------------------");
        this.out();
        this.out("   /**");
        this.out("    * @return the OID value for the designated user-defined OBJECT IDENTIFIER");
        this.out("    * name.");
        this.out("    */");
        this.out("   public ObjectIdentifier getOID(String name) {");
        this.out("      String oid = (String) map.get(name);");
        this.out("      return ((oid == null) ? null : ObjectIdentifier.getInstance(oid));");
        this.out("   }");
        this.outEndClass();
        this.passivate();
    }

    private void out() {
        this.pw.println();
    }

    private void out(String string) {
        this.pw.println(string);
    }

    private boolean isPermissibleType(String string) {
        return Character.isUpperCase(string.charAt(0)) && string.indexOf(".") == -1;
    }

    private String superclassFromType(String string) {
        String string2 = string == null ? "???" : (string.equals("BOOLEAN") ? "ASNBoolean" : (string.equals("INTEGER") ? "ASNInteger" : (string.equals("CHOICE") ? "Choice" : (string.equals("BIT_STRING") ? "BitString" : (string.equals("OCTET_STRING") ? "OctetString" : (string.equals("NULL") ? "Null" : (string.equals("OBJECT_IDENTIFIER") ? "ObjectIdentifier" : (string.equals("SEQUENCE") ? "Sequence" : (string.equals("SEQUENCE_OF") ? "SequenceOf" : (string.equals("SET") ? "Set" : (string.equals("SET_OF") ? "SetOf" : (string.equals("PRINTABLE_STRING") ? "PrintableString" : (string.equals("NUMERIC_STRING") ? "NumericString" : (string.equals("T61_STRING") ? "TeletexString" : (string.equals("VIDEOTEX_STRING") ? "VideotexString" : (string.equals("IA5_STRING") ? "IA5String" : (string.equals("GRAPHIC_STRING") ? "GraphicString" : (string.equals("ISO646_STRING") ? "VisibleString" : (string.equals("GENERAL_STRING") ? "GeneralString" : (string.equals("UNIVERSAL_STRING") ? "UniversalString" : (string.equals("BMP_STRING") ? "BMPString" : (string.equals("UTC_TIME") ? "UTCTime" : (string.equals("GENERALIZED_TIME") ? "GeneralizedTime" : (string.equals("ANY") ? "Any" : string))))))))))))))))))))))));
        return string2;
    }

    private String properFromLower(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private void generate(File file, String string, Map map, String string2, Node node) throws IOException {
        File file2 = this.setupVars(file, string, map, string2);
        this.activate(new PrintWriter(new FileWriter(file2)));
        this.outBeginClass(this.pkgName);
        this.state = 1;
        node.apply(this);
        this.outEndClass();
        this.passivate();
    }

    private File setupVars(File file, String string, Map map, String string2) throws IOException {
        this.tag = null;
        this.moduleName = string;
        this.className = string2;
        this.pkgName = (String)map.get(string);
        if (this.pkgName == null) {
            this.pkgName = string;
        }
        cat.info((Object)("Generating java code for " + this.pkgName + "." + this.className));
        File file2 = null;
        String string3 = this.pkgName.replace('.', File.separatorChar);
        File file3 = new File(file, string3);
        file3.mkdirs();
        file2 = new File(file3, this.className + ".java");
        if (file2.exists() && file2.isFile()) {
            cat.warn((Object)("Destination file " + file2.getPath() + " already exists. Re-creating..."));
            file2.delete();
            file2 = new File(file3, this.className + ".java");
        }
        file2.createNewFile();
        return file2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Generator(Interpreter interpreter) {
        this.ast = interpreter;
        this.data = new LinkedList();
    }
}

