/* $Id: Null.java,v 1.1.1.1 2001/02/24 04:59:04 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;

import org.apache.log4j.Category;

import java.io.EOFException;
import java.io.IOException;

/**
 * The basic implementation of an ASN.1 NULL type.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class Null extends Type implements IType {

	// Constants and vars
	// .......................................................................

	static Category cat = Category.getInstance(Null.class.getName());

	// Constructor(s)
	// .......................................................................

	public Null() {
		this("", new Tag(Tag.NULL), new Object());
	}

	public Null(String name) {
		this(name, new Tag(Tag.NULL), new Object());
	}

	public Null(String name, Tag tag) {
		this(name, tag, new Object());
	}

	public Null(String name, Object value) {
		this(name, new Tag(Tag.NULL), value);
	}

	public Null(String name, Tag tag, Object value) {
		super(name, tag);

		this.value = value;
	}

	// Redefinition of methods in superclass Type
	// .......................................................................

	/**
	 * Decodes a NULL from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void decode(ASNReader is) throws IOException {
		String cn = this.getClass().getName();
		cat.debug("==> "+cn+".decode()");

		is.mark(Integer.MAX_VALUE);
		try {
			is.decodeNull(this);
		} catch (IOException x) {
			cat.warn("Exception ("+String.valueOf(x)+") encountered while decoding a "+cn);
			if (x instanceof ASNException || x instanceof EOFException) {
				cat.warn("Resetting input stream...");
				is.reset();
			}
			throw x;
		}

		cat.debug("<== "+cn+".decode()");
	}

	/**
	 * Encodes a NULL to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void encode(ASNWriter os) throws IOException {
		String cn = this.getClass().getName();
		cat.debug("==> "+cn+".encode()");

		os.encodeNull(this);

		cat.debug("<== "+cn+".encode()");
	}

   // java.lang.Object overloaded methods
   // .......................................................................

	/**
	 * Returns a string representation of this instance.
	 *
	 * @return a string representation of this instance.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer("-- ");
		if (value != null)
			sb.append("NULL");
		else
			sb.append("N/A");

		return sb.toString();
	}
}