/* $Id: AllTests.java,v 1.3 2001/05/26 07:10:25 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;

import java.io.File;

/**
 * TestSuite that runs all the sample tests.<p>
 *
 * @version $Revision: 1.3 $
 * @author  Raif S. Naffah
 */
public class AllTests {

	// Constants and variables
	// -------------------------------------------------------------------------

	// Constructor(s)
	// -------------------------------------------------------------------------

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
      String configFilename = null;
      String dir = System.getProperty("log.dir");
      if (dir == null) {
         System.err.println("System property 'log.dir' undefined. Using 'user.dir'...");
         configFilename = System.getProperty("user.dir")+File.separator+"log.properties";
         if (! new File(configFilename).exists()) {
            System.err.println("${user.dir}/log.properties does not exist. Looking in current working directory...");
            configFilename = "."+File.separator+"log.properties";
            if (! new File(configFilename).exists()) {
               System.err.println("./log.properties does not exist. Using basic configurator...");
               configFilename = null;
            }
         }
      } else {
         configFilename = dir+File.separator+"log.properties";
         if (! new File(configFilename).exists()) {
            System.err.println("${log.dir}/log.properties does not exist. Using 'user.dir'...");
            configFilename = System.getProperty("user.dir")+File.separator+"log.properties";
            if (! new File(configFilename).exists()) {
               System.err.println("${user.dir}/log.properties does not exist. Looking in current working directory...");
               configFilename = "."+File.separator+"log.properties";
               if (! new File(configFilename).exists()) {
                  System.err.println("./log.properties does not exist. Using basic configurator...");
                  configFilename = null;
               }
            }
         }
      }

      if (configFilename == null)
         BasicConfigurator.configure();
      else
         PropertyConfigurator.configure(configFilename);

		TestRunner.run(suite());
	}

	public static Test suite() {
		TestSuite result = new TestSuite("Regression Tests");
		result.addTest(TestOfConstructed.suite());
		result.addTest(TestOfOptionalChoice.suite());
		result.addTest(TestOfBlankOptional.suite());

      return result;
	}

	// Instance methods
	// -------------------------------------------------------------------------
}