/* $Id: TestDer.java,v 1.3 2001/05/26 03:21:20 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

// IMPORTANT: this package is what will get generated by the Main tools class.
// Do not attempt to compile this class before cryptix.asn1.tools.Main has
// exited successfully. In addition, a -P option should be specified when
// invoking the Main tools class to map CryptixUsefulDefinitions (the ASN.1
// module name defined in 'cryptix.asn' definitions file to the following
// package name; eg. -PCryptixUsefulDefinitions=cryptix.asn1.common. For how
// to work this out in an automated way, see the Makefile.
import cryptix.asn1.common.*;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.GregorianCalendar;

/**
 * A test class to exercise, already generated, Java ASN.1 classes with a DER
 * decoder and DER encoder.<p>
 *
 * @version $Revision: 1.3 $
 * @author  Raif S. Naffah
 */
public class TestDer {

	// Constants and variables
	// -------------------------------------------------------------------------

	static Category cat = Category.getInstance(TestDer.class.getName());

	/**
	 * Some OIDs we need in this test.
	 */
	private static final ObjectIdentifier
	MD5_WITH_RSA_ENCRYPTION_OID = ObjectIdentifier.getInstance("1.2.840.113549.1.1.4");

	private static final ObjectIdentifier
	RSA_ENCRYPTION_OID = ObjectIdentifier.getInstance("1.2.840.113549.1.1.1");

	private static final ObjectIdentifier
	ID_AT_COMMON_NAME_OID = ObjectIdentifier.getInstance("2.5.4.3");

	private static final ObjectIdentifier
	ID_AT_COUNTRY_NAME_OID = ObjectIdentifier.getInstance("2.5.4.6");

	private static final ObjectIdentifier
	ID_AT_LOCALITY_NAME_OID = ObjectIdentifier.getInstance("2.5.4.7");

	private static final ObjectIdentifier
	ID_AT_STATE_OR_PROVINCE_NAME_OID = ObjectIdentifier.getInstance("2.5.4.8");

	private static final ObjectIdentifier
	ID_AT_ORGANIZATION_NAME_OID = ObjectIdentifier.getInstance("2.5.4.10");

	private static final ObjectIdentifier
	ID_AT_ORGANIZATIONAL_UNIT_NAME_OID = ObjectIdentifier.getInstance("2.5.4.11");

	/**
	 * Some PrintableStrings we need in this test.
	 */
	private static final PrintableString
	FORGE = PrintableString.getInstance("Forge");

	private static final PrintableString
	FORGE_GROUP = PrintableString.getInstance("Forge Group");

	private static final PrintableString
	FORGE_RESEARCH_PL = PrintableString.getInstance("Forge Research Pty. Limited");

	private static final PrintableString
	ALEXANDRIA = PrintableString.getInstance("Alexandria");

	private static final PrintableString
	NSW = PrintableString.getInstance("NSW");

	private static final PrintableString
	AUSTRALIA = PrintableString.getInstance("Australia");

	private static final Name FORGE_X500_NAME; // blank final
	static {
		Name result = new Name();

		RelativeDistinguishedName rdn1 = new RelativeDistinguishedName();
		AttributeValueAssertion cn = new AttributeValueAssertion();
		cn.setAttributeType(new AttributeType(ID_AT_COMMON_NAME_OID));
		cn.setAttributeValue(new AttributeValue(FORGE));
		rdn1.iterator().add(cn);
		result.iterator().add(rdn1);

		RelativeDistinguishedName rdn3 = new RelativeDistinguishedName();
		AttributeValueAssertion org = new AttributeValueAssertion();
		org.setAttributeType(new AttributeType(ID_AT_ORGANIZATION_NAME_OID));
		org.setAttributeValue(new AttributeValue(FORGE_GROUP));
		rdn3.iterator().add(org);
		result.iterator().add(rdn3);

		RelativeDistinguishedName rdn2 = new RelativeDistinguishedName();
		AttributeValueAssertion unit = new AttributeValueAssertion();
		unit.setAttributeType(new AttributeType(ID_AT_ORGANIZATIONAL_UNIT_NAME_OID));
		unit.setAttributeValue(new AttributeValue(FORGE_RESEARCH_PL));
		rdn2.iterator().add(unit);
		result.iterator().add(rdn2);

		RelativeDistinguishedName rdn4 = new RelativeDistinguishedName();
		AttributeValueAssertion ava4 = new AttributeValueAssertion();
		ava4.setAttributeType(new AttributeType(ID_AT_LOCALITY_NAME_OID));
		ava4.setAttributeValue(new AttributeValue(ALEXANDRIA));
		rdn4.iterator().add(ava4);
		result.iterator().add(rdn4);

		RelativeDistinguishedName rdn5 = new RelativeDistinguishedName();
		AttributeValueAssertion ava5 = new AttributeValueAssertion();
		ava5.setAttributeType(new AttributeType(ID_AT_STATE_OR_PROVINCE_NAME_OID));
		ava5.setAttributeValue(new AttributeValue(NSW));
		rdn5.iterator().add(ava5);
		result.iterator().add(rdn5);

		RelativeDistinguishedName rdn6 = new RelativeDistinguishedName();
		AttributeValueAssertion country = new AttributeValueAssertion();
		country.setAttributeType(new AttributeType(ID_AT_COUNTRY_NAME_OID));
		country.setAttributeValue(new AttributeValue(AUSTRALIA));
		rdn6.iterator().add(country);
		result.iterator().add(rdn6);

		FORGE_X500_NAME = result;
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static final void main(String[] args) throws Exception {
      String configFilename = null;
      String dir = System.getProperty("log.dir");
      if (dir == null) {
         System.err.println("System property 'log.dir' undefined. Using 'user.dir'...");
         configFilename = System.getProperty("user.dir")+File.separator+"log.properties";
         if (! new File(configFilename).exists()) {
            System.err.println("${user.dir}/log.properties does not exist. Looking in current working directory...");
            configFilename = "."+File.separator+"log.properties";
            if (! new File(configFilename).exists()) {
               System.err.println("./log.properties does not exist. Using basic configurator...");
               configFilename = null;
            }
         }
      } else {
         configFilename = dir+File.separator+"log.properties";
         if (! new File(configFilename).exists()) {
            System.err.println("${log.dir}/log.properties does not exist. Using 'user.dir'...");
            configFilename = System.getProperty("user.dir")+File.separator+"log.properties";
            if (! new File(configFilename).exists()) {
               System.err.println("${user.dir}/log.properties does not exist. Looking in current working directory...");
               configFilename = "."+File.separator+"log.properties";
               if (! new File(configFilename).exists()) {
                  System.err.println("./log.properties does not exist. Using basic configurator...");
                  configFilename = null;
               }
            }
         }
      }

      if (configFilename == null)
         BasicConfigurator.configure();
      else
         PropertyConfigurator.configure(configFilename);

		cat.info("");
		cat.info("-------------------------------------------------------");
		cat.info("Test DER");
		cat.info("-------------------------------------------------------");
		cat.info("");

		if (args.length < 1) {
			cat.info("Usage:");
			cat.info("  java test.TestDer <encoding>");
			System.exit(1);
		}

		File f = new File(args[0]);
		if (!f.isFile()) {
			cat.error("File "+f.getAbsolutePath()+" does not exist");
			System.exit(2);
		}

		String data = f.getAbsolutePath();

		cat.info("Can we access \""+data+"\" ?");
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(f);
		} catch (FileNotFoundException e) {
			cat.error("File "+f.getAbsolutePath()+" does not exist");
			System.exit(3);
		}

		cat.info("Yes...");

		cat.info("");
		cat.info("Can we access the x509 instance present inside?");

		ASNReader der = Factory.getDecoder("DER");
		if (der == null) {
			cat.error("Unable to instantiate a DER Decoder");
			System.exit(4);
		}

		cat.info("Yes...");
		Certificate x509 = new Certificate();

		der.open(fis); // prepare for decoding
		x509.decode(der);
		der.close();

		cat.info(String.valueOf(x509));

		// now check that both the signature algorithm in the Certificate
		// matches the component "signature" inside the CertificateInfo
		AlgorithmIdentifier signatureAlgorithm = x509.getSignatureAlgorithm();
		CertificateInfo certificateInfo = x509.getCertificateInfo();
		AlgorithmIdentifier sigID = certificateInfo.getSignature();

		String v1 = signatureAlgorithm.getAlgorithm().stringValue();
		String v2 = sigID.getAlgorithm().stringValue();
		cat.info("");
		cat.info("Do signature OIDs match?");
		cat.info("   Certificate.signatureAlgorithm.algorithm = \""+v1+"\"");
		cat.info("   Certificate.certificateInfo.signature.algorithm = \""+v2+"\"");
		if (v1.equals(v2))
			cat.info("Yes. OID = \""+v1+"\"");
		else
			cat.info("No. Outer OID = \""+v1+"\", inner OID + \""+v2+"\"");

		cat.info("");
		cat.info("Extract the Certificate's signer signature bytes (displayed in base 16)");
		byte[] sb = x509.getSignature().byteArrayValue();
		BigInteger s = new BigInteger(1, sb); // always positive
		cat.info(s.toString(16));

		cat.info("");
		cat.info("Extract the CertificateInfo's issuer name");
		Name ca = certificateInfo.getIssuer();
		cat.info(String.valueOf(ca));

		cat.info("");
		cat.info("Done decoding tests...");
		cat.info("");

		cat.info("Begin encoding test...");

		// NOTE: you should have a security provider for RSA (both keypair
		// generations and signature) already installed at this point.
		// the following code assumes it is the case.
		// generating an RSA keypair
		KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
		kpg.initialize(1024);
		KeyPair kp = kpg.generateKeyPair();
		PublicKey pubK = kp.getPublic();
		PrivateKey privK = kp.getPrivate();

		cat.info("Manufacturing a CertificateInfo...");
		AlgorithmIdentifier scheme = new AlgorithmIdentifier();
		scheme.setAlgorithm(MD5_WITH_RSA_ENCRYPTION_OID);

		Validity validity = new Validity();
		validity.setNotBefore(UTCTime.getInstance(new GregorianCalendar(2000, 11,  1).getTime()));
		validity.setNotAfter(UTCTime.getInstance(new GregorianCalendar(2001, 10, 30).getTime()));

		SubjectPublicKeyInfo sKInfo = new SubjectPublicKeyInfo();
		AlgorithmIdentifier pkix = new AlgorithmIdentifier();
		pkix.setAlgorithm(RSA_ENCRYPTION_OID);
		sKInfo.setAlgorithm(pkix);
		sKInfo.setSubjectPublicKey(BitString.getInstance(pubK.getEncoded()));

		CertificateInfo info = new CertificateInfo(); // use default value for Version!
		info.setSerialNumber(new CertificateSerialNumber(ASNInteger.getInstance(100)));
		info.setSignature(scheme);
		info.setIssuer(FORGE_X500_NAME);
		info.setValidity(validity);
		info.setSubject(FORGE_X500_NAME);
		info.setSubjectPublicKeyInfo(sKInfo);

		cat.info("cert-info="+String.valueOf(info));

		// sign it
		cat.info("Signing the CertificateInfo instance...");
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
//		FileOutputStream f1 = new FileOutputStream("./cert-info.der");
		ASNWriter dos = Factory.getEncoder("DER");

		dos.open(baos);
//		dos.open(f1);
		info.encode(dos);
		dos.close();

		byte[] toSign = baos.toByteArray();
//		FileInputStream f2 = new FileInputStream("./cert-info.der");
//		byte[] toSign = new byte[f2.available()];
//		f2.read(toSign);
//		f2.close();

		Signature sigMaker = Signature.getInstance("MD5withRSA");

		sigMaker.initSign(privK);
		sigMaker.update(toSign);
		byte[] signed = sigMaker.sign();

		cat.info("Assembling the certificate...");
		Certificate cert = new Certificate();
		cert.setCertificateInfo(info);
		cert.setSignatureAlgorithm(scheme);
		cert.setSignature(BitString.getInstance(signed));

		cat.info("cert="+String.valueOf(cert));

		cat.info("DER encoding the certificate...");
		baos = new ByteArrayOutputStream();
//		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		dos.open(baos);
		cert.encode(dos);
		dos.close();

		cat.info("");
		cat.info("Done encoding tests...");
		cat.info("");

		cat.info("Decoding the just encoded structure (symmetry test)...");

		x509 = new Certificate();
		cat.info("");
		cat.info("Value before reading the stream...");
		cat.info(String.valueOf(x509));

		cat.info("");
		cat.info("Reading the stream...");
		ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
		der.open(bais); // prepare for decoding
		x509.decode(der);
		der.close();

		cat.info("");
		cat.info("Value after reading the stream...");
		cat.info(String.valueOf(x509));

		cat.info("");
		cat.info("Done symmetry test...");
		cat.info("");
	}
}