/* $Id: TestOfConstructed.java,v 1.3 2001/05/26 07:10:25 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * Regression test for bug #422601.
 *
 * Ensures that SEQUENCE, SET, SEQUENCE OF and SET OF types and subtypes are
 * instantiated with the constructed flag (in their tag) set.<p>
 *
 * @version $Revision: 1.3 $
 * @author  Raif S. Naffah
 */
public class TestOfConstructed extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

	SeqType seq1;
	SeqType seq2;
	SetType set1;
	SetType set2;
	SeqOfType sqo1;
	SeqOfType sqo2;
	SetOfType sto1;
	SetOfType sto2;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfConstructed(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfConstructed.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testAnonymousSequenceTag() {
		assertTrue("Tag of anonymous SEQUENCE is constructed?", seq1.tag().isConstructed());
	}

	public void testNamedSequenceTag() {
		assertTrue("Tag of named SEQUENCE is constructed?", seq2.tag().isConstructed());
	}

	public void testAnonymousSetTag() {
		assertTrue("Tag of anonymous SET is constructed?", set1.tag().isConstructed());
	}

	public void testNamedSetTag() {
		assertTrue("Tag of named SET is constructed?", set2.tag().isConstructed());
	}

	public void testAnonymousSequenceOfTag() {
		assertTrue("Tag of anonymous SEQUENCE OF is constructed?", sqo1.tag().isConstructed());
	}

	public void testNamedSequenceOfTag() {
		assertTrue("Tag of named SEQUENCE OF is constructed?", sqo2.tag().isConstructed());
	}

	public void testAnonymousSetOfTag() {
		assertTrue("Tag of anonymous SET OF is constructed?", sto1.tag().isConstructed());
	}

	public void testNamedSetOfTag() {
		assertTrue("Tag of named SET OF is constructed?", sto2.tag().isConstructed());
	}

	protected void setUp() {
		seq1 = new SeqType();
		seq2 = new SeqType("MySeq");
		set1 = new SetType();
		set2 = new SetType("MySet");
		sqo1 = new SeqOfType();
		sqo2 = new SeqOfType("MySeqOf");
		sto1 = new SetOfType();
		sto2 = new SetOfType("MySetOf");
	}
}