/* $Id: TestOfOptionalChoice.java,v 1.2 2001/05/26 07:10:25 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

import java.io.ByteArrayOutputStream;

/**
 * Regression test for bug #425895.
 *
 * OPTIONAL CHOICE types throw BlankElementException in encoding operations.<p>
 *
 * @version $Revision: 1.2 $
 * @author  Raif S. Naffah
 */
public class TestOfOptionalChoice extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

	SeqTypeA seq;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfOptionalChoice(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfOptionalChoice.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testEncodingOptionalChoice() {
      try {
		   ASNWriter der = Factory.getEncoder("DER");
         ByteArrayOutputStream baos = new ByteArrayOutputStream();
         der.open(baos);
         seq.encode(der);
         der.close();

   		assertTrue(true);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	protected void setUp() {
		seq = new SeqTypeA("sequence");
      seq.setX(ASNInteger.getInstance(2));
	}
}