/* $Id: $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import java.util.Vector;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * Test of ....<p>
 *
 * @version $Revision: $
 * @author  Raif S. Naffah
 */
public class TestOfxxx extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

	protected Vector fEmpty;
	protected Vector fFull;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfxxx(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfxxx.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testCapacity() {
		int size = fFull.size();
		for (int i = 0; i < 100; i++)
			fFull.addElement(new Integer(i));
		assertTrue(fFull.size() == 100+size);
	}

	public void testClone() {
		Vector clone = (Vector) fFull.clone();
		assertTrue(clone.size() == fFull.size());
		assertTrue(clone.contains(new Integer(1)));
	}

	public void testContains() {
		assertTrue(fFull.contains(new Integer(1)));
		assertTrue(!fEmpty.contains(new Integer(1)));
	}

	public void testElementAt() {
		Integer i = (Integer) fFull.elementAt(0);
		assertTrue(i.intValue() == 1);
		try {
			Integer j= (Integer)fFull.elementAt(fFull.size());
		} catch (ArrayIndexOutOfBoundsException x) {
			return;
		}

		fail("Should raise an ArrayIndexOutOfBoundsException");
	}

	public void testRemoveAll() {
		fFull.removeAllElements();
		fEmpty.removeAllElements();
		assertTrue(fFull.isEmpty());
		assertTrue(fEmpty.isEmpty());
	}

	public void testRemoveElement() {
		fFull.removeElement(new Integer(3));
		assertTrue(!fFull.contains(new Integer(3)));
	}

	protected void setUp() {
		fEmpty= new Vector();
		fFull= new Vector();
		fFull.addElement(new Integer(1));
		fFull.addElement(new Integer(2));
		fFull.addElement(new Integer(3));
	}
}