/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Category;

public class ASNBoolean
extends Type
implements IType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$ASNBoolean != null ? class$Lcryptix$asn1$lang$ASNBoolean : (class$Lcryptix$asn1$lang$ASNBoolean = ASNBoolean.class$("cryptix.asn1.lang.ASNBoolean"))).getName());
    public static final ASNBoolean TRUE = new ASNBoolean("TRUE", Boolean.TRUE);
    public static final ASNBoolean FALSE = new ASNBoolean("FALSE", Boolean.FALSE);
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$ASNBoolean;

    public static ASNBoolean getInstance(String string) {
        return new ASNBoolean("", string);
    }

    public static ASNBoolean getInstance(Boolean bl) {
        return new ASNBoolean("", bl);
    }

    public static ASNBoolean getInstance(boolean bl) {
        return new ASNBoolean("", new Boolean(bl));
    }

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        aSNReader.mark(Integer.MAX_VALUE);
        try {
            Boolean bl = aSNReader.decodeBoolean(this);
            if (bl == null) {
                throw new ElementNotFoundException(string);
            }
            this.value(bl);
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void encode(ASNWriter aSNWriter) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encode()"));
        Object object = this.value();
        if (object != null) {
            aSNWriter.encodeBoolean(this, (Boolean)object);
        } else {
            object = this.defaultValue();
            if (object != null) {
                cat.warn((Object)("Encoding default value for " + string));
                aSNWriter.encodeBoolean(this, (Boolean)object);
            } else if (!this.isOptional()) {
                throw new BlankElementException(string);
            }
        }
        cat.debug((Object)("<== " + string + ".encode()"));
    }

    public void value(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.value = new Boolean((String)object);
        } else if (object instanceof Boolean) {
            this.value = (Boolean)object;
        } else if (object instanceof ASNBoolean) {
            this.value = ((ASNBoolean)object).booleanValue();
        } else {
            throw new ClassCastException();
        }
    }

    public Boolean booleanValue() {
        return (Boolean)this.value;
    }

    protected boolean sameValue(Object object) {
        Boolean bl = this.booleanValue();
        return bl == null ? false : bl.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        if (this.value != null) {
            stringBuffer.append(String.valueOf(this.booleanValue()));
        } else {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ASNBoolean() {
        super("", new Tag(1));
    }

    public ASNBoolean(String string) {
        super(string, new Tag(1));
    }

    public ASNBoolean(String string, Tag tag) {
        super(string, tag);
    }

    public ASNBoolean(String string, Object object) {
        this(string, new Tag(1), object);
    }

    public ASNBoolean(String string, Tag tag, Object object) {
        super(string, tag);
        this.value(object);
        if (this.value != null) {
            this.defaultValue(this.value);
        }
    }
}

