/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.CompoundType;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.log4j.Category;

public abstract class SequenceOf
extends CompoundType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$SequenceOf != null ? class$Lcryptix$asn1$lang$SequenceOf : (class$Lcryptix$asn1$lang$SequenceOf = SequenceOf.class$("cryptix.asn1.lang.SequenceOf"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$SequenceOf;

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        this.reset();
        aSNReader.mark(Integer.MAX_VALUE);
        ASNReader aSNReader2 = aSNReader.decodeStructure(this);
        if (aSNReader2 == null) {
            cat.warn((Object)(string + " not found. Backtracking..."));
            aSNReader.reset();
            throw new ElementNotFoundException(string);
        }
        while (true) {
            ArrayList arrayList = this.cloneComponents();
            int n = 0;
            cat.info((Object)("Looking for a valid " + string + " (SEQUENCE OF) frame..."));
            try {
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    Type type = (Type)iterator.next();
                    try {
                        cat.info((Object)("Expecting a " + type.getClass().getName()));
                        type.decode(aSNReader2);
                        cat.info((Object)("Found a " + type.getClass().getName()));
                        ++n;
                    }
                    catch (ElementNotFoundException elementNotFoundException) {
                        if (!type.isOptional()) {
                            cat.warn((Object)(String.valueOf(elementNotFoundException) + ". Backtracking..."));
                            aSNReader.reset();
                            throw elementNotFoundException;
                        }
                        cat.warn((Object)(String.valueOf(elementNotFoundException) + ". Ignoring..."));
                    }
                }
                cat.info((Object)("Eureka! Adding another frame to " + string + "'s (SEQUENCE OF) collection..."));
                this.iterator().add(arrayList);
            }
            catch (EOFException eOFException) {
                cat.warn((Object)"Exhausted the input stream...");
                if (n > 0) {
                    cat.info((Object)("Eureka! Adding last frame to " + string + "'s (SEQUENCE OF) collection..."));
                    this.iterator().add(arrayList);
                }
                cat.debug((Object)("<== " + string + ".decode()"));
                return;
            }
        }
    }

    public void value(Object object) {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".value()"));
        cat.debug((Object)("value=" + String.valueOf(object)));
        cat.debug((Object)("value is a " + String.valueOf(object.getClass().getName())));
        if (object instanceof IType) {
            cat.debug((Object)("Tag=" + String.valueOf(((IType)object).tag())));
        }
        this.reset();
        if (object instanceof IType) {
            object = ((IType)object).value();
            cat.debug((Object)("value now=" + String.valueOf(object)));
            cat.debug((Object)("value is now a " + String.valueOf(object.getClass().getName())));
            if (object instanceof IType) {
                cat.debug((Object)("Tag=" + String.valueOf(((IType)object).tag())));
            }
        }
        if (object instanceof ArrayList) {
            cat.warn((Object)"Assume a SEQUENCE OF one component...");
            Iterator iterator = ((AbstractList)((ArrayList)object)).iterator();
            int n = 1;
            while (iterator.hasNext()) {
                cat.info((Object)("Processing frame #" + String.valueOf(n) + " of " + string));
                IType iType = (IType)((AbstractList)this.cloneComponents()).iterator().next();
                cat.info((Object)("Assigning value to " + iType.getClass().getName()));
                iType.value(iterator.next());
                this.iterator().add(iType);
                ++n;
            }
        } else {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.printStackTrace(System.err);
            throw runtimeException;
        }
        cat.debug((Object)("<== " + string + ".value()"));
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("-- Begin ").append(string).append(" (SEQUENCE OF)").append(string2);
        int n = 1;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            stringBuffer.append("-- frame #").append(n++).append(" (").append(e.getClass().getName()).append("): ").append(String.valueOf(e)).append(string2);
        }
        stringBuffer.append("-- End ").append(string).append(" (SEQUENCE OF)");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SequenceOf(Tag tag) {
        super("", tag);
    }

    public SequenceOf(String string, Tag tag) {
        super(string, tag);
    }

    public SequenceOf(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            if (object instanceof ArrayList) {
                this.value(object);
            } else {
                throw new ClassCastException();
            }
        }
    }
}

