/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.Any;
import cryptix.asn1.lang.CompoundType;
import cryptix.asn1.lang.IIterativeType;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.log4j.Category;

public abstract class Set
extends CompoundType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$Set != null ? class$Lcryptix$asn1$lang$Set : (class$Lcryptix$asn1$lang$Set = Set.class$("cryptix.asn1.lang.Set"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$Set;

    public void decode(ASNReader aSNReader) throws IOException {
        Type type;
        ListIterator listIterator;
        int n;
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        this.reset();
        aSNReader.mark(Integer.MAX_VALUE);
        ASNReader aSNReader2 = aSNReader.decodeStructure(this);
        if (aSNReader2 == null) {
            cat.warn((Object)(string + " not found. Backtracking..."));
            aSNReader.reset();
            throw new ElementNotFoundException(string);
        }
        block3: do {
            listIterator = this.iterator();
            n = 0;
            while (listIterator.hasNext()) {
                type = (Type)listIterator.next();
                if (!type.isBlank()) continue;
                try {
                    aSNReader2.mark(Integer.MAX_VALUE);
                    cat.info((Object)("Looking for " + type.getClass().getName()));
                    type.decode(aSNReader2);
                    cat.info((Object)("Found " + type.getClass().getName()));
                    ++n;
                }
                catch (EOFException eOFException) {
                    cat.info((Object)"Exhausted the input stream. Breaking...");
                    break block3;
                }
                catch (ElementNotFoundException elementNotFoundException) {
                    cat.warn((Object)(String.valueOf(elementNotFoundException) + ". Backtracking..."));
                    if (type.isOptional()) continue;
                    aSNReader2.reset();
                }
            }
        } while (n != 0);
        listIterator = this.iterator();
        while (listIterator.hasNext()) {
            type = (Type)listIterator.next();
            if (!type.isBlank() || type.isOptional()) continue;
            cat.error((Object)("After completely parsing " + string + " (SET), a non optional type (" + type.getClass().getName() + ") was found missing"));
            throw new ElementNotFoundException(string);
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void reset() {
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            ((IType)listIterator.next()).reset();
        }
    }

    public Object value() {
        return this.cloneComponents();
    }

    public void value(Object object) {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".value(" + String.valueOf(object) + ")"));
        this.reset();
        if (object instanceof IType) {
            object = ((IType)object).value();
        }
        Iterator iterator = object instanceof ArrayList ? ((AbstractList)((ArrayList)object)).iterator() : ((AbstractList)((ArrayList)((Any)object).value())).iterator();
        ListIterator listIterator = this.iterator();
        while (iterator.hasNext() && listIterator.hasNext()) {
            IType iType = (IType)iterator.next();
            IType iType2 = (IType)listIterator.next();
            cat.info((Object)("Assigning value from " + iType.getClass().getName() + " to " + iType2.getClass().getName()));
            if (iType instanceof IIterativeType) {
                iType2.value(iType);
                continue;
            }
            iType2.value(iType.value());
        }
        cat.debug((Object)("<== " + string + ".value()"));
    }

    public boolean isBlank() {
        boolean bl = true;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType = (IType)listIterator.next();
            if (iType.isBlank()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public ListIterator iterator() {
        return ((AbstractList)this.components).listIterator();
    }

    protected void initInternal() {
        super.initInternal();
        this.value = null;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("-- Begin ").append(string).append(" (SET)").append(string2);
        int n = 1;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType = (IType)listIterator.next();
            stringBuffer.append("--   field #").append(n++).append(" (").append(iType.getClass().getName()).append("): ").append(String.valueOf(iType)).append(string2);
        }
        stringBuffer.append("-- End ").append(string).append(" (SET)");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Set(Tag tag) {
        super("", tag);
    }

    public Set(String string, Tag tag) {
        super(string, tag);
    }

    public Set(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            if (object instanceof ArrayList) {
                this.value(object);
            } else {
                throw new ClassCastException();
            }
        }
    }
}

