/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.tool;

import cryptix.asn1.analysis.DepthFirstAdapter;
import cryptix.asn1.node.AClassAttr;
import cryptix.asn1.node.AExplicitTagDefault;
import cryptix.asn1.node.ALParenAuxBet1;
import cryptix.asn1.node.ALowerAuxBet1;
import cryptix.asn1.node.ALowerBetBraces;
import cryptix.asn1.node.ALowerNamedType;
import cryptix.asn1.node.ALowerObjIdComponent;
import cryptix.asn1.node.AModuleDefinition;
import cryptix.asn1.node.AModuleIdentifier;
import cryptix.asn1.node.ANumericClassNumber;
import cryptix.asn1.node.ANumericObjIdComponent;
import cryptix.asn1.node.AObjIdCompLst;
import cryptix.asn1.node.AOidAuxBet11;
import cryptix.asn1.node.APositiveAuxBet1;
import cryptix.asn1.node.APositiveBetBraces;
import cryptix.asn1.node.ATagging;
import cryptix.asn1.node.ATypeAssignment;
import cryptix.asn1.node.AValueAssignment;
import cryptix.asn1.node.Node;
import cryptix.asn1.node.PAuxBet1;
import cryptix.asn1.node.PAuxBet11;
import cryptix.asn1.node.PAuxBet3;
import cryptix.asn1.node.PClassAttr;
import cryptix.asn1.node.PClassNumber;
import cryptix.asn1.node.PTagging;
import cryptix.asn1.node.PType;
import cryptix.asn1.node.PValue;
import cryptix.asn1.node.TLess;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Category;

public class Interpreter
extends DepthFirstAdapter {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$tool$Interpreter != null ? class$Lcryptix$asn1$tool$Interpreter : (class$Lcryptix$asn1$tool$Interpreter = Interpreter.class$("cryptix.asn1.tool.Interpreter"))).getName());
    private Hashtable modules = new Hashtable();
    private Hashtable oids;
    private Hashtable types;
    private String[] stack;
    private int top;
    private String prefix;
    private static /* synthetic */ Class class$Lcryptix$asn1$tool$Interpreter;

    public void defaultOut(Node node) {
        cat.debug((Object)("node: " + node.getClass().getName() + "=" + node));
    }

    public void inAModuleDefinition(AModuleDefinition aModuleDefinition) {
        this.oids = new Hashtable();
        this.types = new Hashtable();
        this.stack = new String[64];
        this.top = -1;
        this.prefix = "";
    }

    public void outAModuleDefinition(AModuleDefinition aModuleDefinition) {
        Object object;
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        hashtable.put("OID", this.oids);
        hashtable.put("TYPE", this.types);
        PTagging pTagging = aModuleDefinition.getTagging();
        boolean bl = false;
        if (pTagging != null) {
            object = ((ATagging)pTagging).getTagDefault();
            bl = !(object instanceof AExplicitTagDefault);
        }
        hashtable.put("IMPLICIT_TAGGING", new Boolean(bl));
        object = ((AModuleIdentifier)aModuleDefinition.getModuleIdentifier()).getUpper().getText();
        this.modules.put(object, hashtable);
        this.oids = null;
        this.types = null;
        this.stack = null;
        this.top = -1;
        this.prefix = null;
    }

    public void outAObjIdCompLst(AObjIdCompLst aObjIdCompLst) {
        String string = "";
        if (this.top > -1) {
            string = this.stack[this.top--];
        }
        while (this.top > -1) {
            string = this.stack[this.top--] + "." + string;
        }
        this.stack[++this.top] = string;
        cat.debug((Object)("outAObjIdCompLst(): Assembled OID: " + string));
    }

    public void outANumericObjIdComponent(ANumericObjIdComponent aNumericObjIdComponent) {
        cat.debug((Object)("node: " + aNumericObjIdComponent.getClass().getName() + "=" + aNumericObjIdComponent));
        String string = aNumericObjIdComponent.getNumber().getText().trim();
        this.stack[++this.top] = string;
        cat.info((Object)("outANumericObjIdComponent(): Pushed \"" + string + "\""));
    }

    public void outALowerObjIdComponent(ALowerObjIdComponent aLowerObjIdComponent) {
        cat.debug((Object)("node: " + aLowerObjIdComponent.getClass().getName() + "=" + aLowerObjIdComponent));
        String string = aLowerObjIdComponent.getLower().getText().trim();
        PClassAttr pClassAttr = aLowerObjIdComponent.getClassAttr();
        if (pClassAttr == null) {
            this.resolveOID(string);
        } else {
            PClassNumber pClassNumber = ((AClassAttr)pClassAttr).getClassNumber();
            String string2 = pClassNumber.toString().trim();
            cat.info((Object)("outALowerObjIdComponent(): Assembled OID: " + string + "=\"" + string2 + "\""));
            this.oids.put(string, string2);
        }
    }

    public void outANumericClassNumber(ANumericClassNumber aNumericClassNumber) {
        cat.debug((Object)("node: " + aNumericClassNumber.getClass().getName() + "=" + aNumericClassNumber));
        String string = aNumericClassNumber.getNumber().getText().trim();
        this.stack[++this.top] = string;
        cat.info((Object)("outANumericClassNumber(): Pushed \"" + string + "\""));
    }

    public void inATypeAssignment(ATypeAssignment aTypeAssignment) {
        String string = aTypeAssignment.getUpper().getText().trim();
        PType pType = aTypeAssignment.getType();
        cat.info((Object)"inATypeAssignment():");
        cat.info((Object)("  upper::" + string));
        cat.info((Object)("  type::" + pType.getClass().getName() + "=\"" + pType + "\""));
        this.prefix = string;
    }

    public void outATypeAssignment(ATypeAssignment aTypeAssignment) {
        cat.debug((Object)("node: " + aTypeAssignment.getClass().getName() + "=" + aTypeAssignment));
        String string = aTypeAssignment.getUpper().getText().trim();
        PType pType = aTypeAssignment.getType();
        cat.info((Object)"outATypeAssignment():");
        cat.info((Object)("  upper::" + string));
        cat.info((Object)("  type::" + pType.getClass().getName() + "=\"" + pType + "\""));
        this.types.put(string, pType);
        cat.info((Object)("Defined \"" + string + "\""));
        this.prefix = "";
    }

    public void outAValueAssignment(AValueAssignment aValueAssignment) {
        cat.debug((Object)("node: " + aValueAssignment.getClass().getName() + "=" + aValueAssignment));
        String string = aValueAssignment.getLower().getText().trim();
        PType pType = aValueAssignment.getType();
        PValue pValue = aValueAssignment.getValue();
        cat.info((Object)"outAValueAssignment():");
        cat.info((Object)("  identifier::" + string));
        cat.info((Object)("  type::" + pType.getClass().getName() + "=\"" + pType + "\""));
        cat.info((Object)("  value::" + pValue.getClass().getName() + "=\"" + pValue + "\""));
        if (pType.toString().trim().equals("OBJECT IDENTIFIER")) {
            String string2 = "";
            if (this.top > -1) {
                string2 = this.stack[this.top--];
            }
            while (this.top > -1) {
                string2 = this.stack[this.top--] + "." + string2;
            }
            cat.info((Object)("outAValueAssignment(): Assembled OID=\"" + string2 + "\""));
            this.oids.put(string, string2);
        }
    }

    public void outALowerBetBraces(ALowerBetBraces aLowerBetBraces) {
        cat.debug((Object)("node: " + aLowerBetBraces.getClass().getName() + "=" + aLowerBetBraces));
        String string = aLowerBetBraces.getLower().getText().trim();
        PAuxBet1 pAuxBet1 = aLowerBetBraces.getAuxBet1();
        cat.info((Object)"outALowerBetBraces():");
        cat.info((Object)("  lower::" + string));
        cat.info((Object)("  aux_bet1::" + pAuxBet1.getClass().getName() + "=\"" + pAuxBet1 + "\""));
        if (pAuxBet1 == null) {
            return;
        }
        if (pAuxBet1 instanceof ALParenAuxBet1) {
            PClassNumber pClassNumber = ((ALParenAuxBet1)pAuxBet1).getClassNumber();
            String string2 = pClassNumber.toString().trim();
            cat.info((Object)("outALowerBetBraces(): Assembled OID: " + string + "=\"" + string2 + "\""));
            this.oids.put(string, string2);
        } else if (pAuxBet1 instanceof APositiveAuxBet1) {
            this.resolveOID(string);
            String string3 = ((APositiveAuxBet1)pAuxBet1).getNumber().getText().trim();
            this.stack[++this.top] = string3;
            cat.info((Object)("outALowerBetBraces(): Pushed \"" + string3 + "\""));
        } else if (pAuxBet1 instanceof ALowerAuxBet1) {
            this.updateStack(string);
        }
    }

    public void inAPositiveBetBraces(APositiveBetBraces aPositiveBetBraces) {
        cat.debug((Object)("node: " + aPositiveBetBraces.getClass().getName() + "=" + aPositiveBetBraces));
        String string = aPositiveBetBraces.getNumber().getText().trim();
        PAuxBet3 pAuxBet3 = aPositiveBetBraces.getAuxBet3();
        cat.info((Object)"inAPositiveBetBraces():");
        cat.info((Object)("  number::" + string));
        cat.info((Object)("  aux_bet3::" + pAuxBet3.getClass().getName() + "=\"" + pAuxBet3 + "\""));
        this.stack[++this.top] = string;
        cat.info((Object)("inAPositiveBetBraces(): Pushed \"" + string + "\""));
    }

    public void outALowerAuxBet1(ALowerAuxBet1 aLowerAuxBet1) {
        cat.debug((Object)("node: " + aLowerAuxBet1.getClass().getName() + "=" + aLowerAuxBet1));
        String string = aLowerAuxBet1.getLower().getText().trim();
        PAuxBet11 pAuxBet11 = aLowerAuxBet1.getAuxBet11();
        cat.info((Object)"outALowerAuxBet1():");
        cat.info((Object)("  lower::" + string));
        cat.info((Object)("  aux_bet11::" + pAuxBet11.getClass().getName() + "=\"" + pAuxBet11 + "\""));
        if (pAuxBet11 == null) {
            this.updateStack(string);
        } else if (pAuxBet11 instanceof AOidAuxBet11) {
            this.updateStack(string);
        }
    }

    public void outALowerNamedType(ALowerNamedType aLowerNamedType) {
        cat.debug((Object)("node: " + aLowerNamedType.getClass().getName() + "=" + aLowerNamedType));
        String string = aLowerNamedType.getLower().getText().trim();
        TLess tLess = aLowerNamedType.getLess();
        PType pType = aLowerNamedType.getType();
        cat.info((Object)"outALowerNamedType():");
        cat.info((Object)("  lower::" + string));
        if (tLess != null) {
            cat.info((Object)("  less::" + tLess.getClass().getName() + "=\"" + tLess + "\""));
        }
        cat.info((Object)("  type::" + pType.getClass().getName() + "=\"" + pType + "\""));
        string = this.prefix + "." + string;
        this.types.put(string, pType);
        cat.info((Object)("Defined \"" + string + "\""));
    }

    private String resolveOID(String string) {
        String string2 = (String)this.oids.get(string);
        cat.debug((Object)("resolveOID(" + string + ") --> " + string2));
        if (string2 == null) {
            throw new RuntimeException("Forward reference to \"" + string + "\"...");
        }
        this.stack[++this.top] = string2;
        cat.info((Object)("Pushed \"" + string2 + "\""));
        return string2;
    }

    private String updateStack(String string) {
        String string2;
        String string3 = "";
        if (this.top > -1) {
            string3 = this.stack[this.top--];
        }
        while (this.top > -1) {
            string3 = this.stack[this.top--] + "." + string3;
        }
        this.resolveOID(string);
        this.stack[this.top] = string2 = this.stack[this.top] + "." + string3;
        cat.debug((Object)("top --> [STACK]=" + string + "." + string3 + ", or \"" + string2 + "\""));
        return string2;
    }

    public void dump(String string) {
        Object object;
        Object object2;
        Enumeration enumeration;
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        Hashtable hashtable2 = (Hashtable)hashtable.get("OID");
        if (hashtable2.size() != 0) {
            System.out.println();
            System.out.println("OIDs defined in module " + string + "...");
            enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = (String)hashtable2.get(object2);
                System.out.println("   " + (String)object2 + "=\"" + (String)object + "\"");
            }
        }
        if (((Hashtable)(object2 = (Hashtable)hashtable.get("TYPE"))).size() != 0) {
            System.out.println();
            System.out.println("Types defined in module " + string + "...");
            enumeration = ((Hashtable)object2).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                object = (Node)((Hashtable)object2).get(string2);
                System.out.println("   " + string2 + "=" + object);
            }
        }
    }

    public Node getComponent(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        Hashtable hashtable2 = (Hashtable)hashtable.get("TYPE");
        Node node = (Node)hashtable2.get(string2);
        cat.debug((Object)("getComponent(\"" + string + "\", \"" + string2 + "\") --> " + node));
        return node;
    }

    public Map getComponents(String string) {
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        Hashtable hashtable2 = (Hashtable)hashtable.get("TYPE");
        return hashtable2;
    }

    public Map getOIDs(String string) {
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        Hashtable hashtable2 = (Hashtable)hashtable.get("OID");
        return hashtable2;
    }

    public boolean getImplicitTagging(String string) {
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        Boolean bl = (Boolean)hashtable.get("IMPLICIT_TAGGING");
        return bl;
    }

    public boolean isPublic(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.modules.get(string);
        LinkedList linkedList = (LinkedList)hashtable.get("EXPORT");
        if (linkedList == null) {
            return true;
        }
        return linkedList.contains(string2);
    }

    public Map getModules() {
        return this.modules;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

