/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.tool;

import cryptix.asn1.node.Node;
import cryptix.asn1.tool.DisplayTree;
import cryptix.asn1.tool.PrintWalker;
import cryptix.asn1.tool.TreeBuilder;
import cryptix.asn1.tool.Version;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PushbackReader;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PrintTree {
    private JPopupMenu popup;
    private JFrame frame;
    private JTree table;

    public static void main(String[] stringArray) {
        System.out.print(Version.banner());
        if (stringArray.length < 1 || stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
            System.out.println("Usage:");
            System.out.println("  java nzdis.lang.kif.tool.PrintTree [-g|--gui] filename");
            System.exit(1);
        }
        String string = stringArray.length == 2 ? stringArray[1] : stringArray[0];
        try {
            Node node = TreeBuilder.getNode(new PushbackReader(new BufferedReader(new FileReader(string)), 1024));
            PrintTree printTree = new PrintTree();
            if (stringArray[0].equals("--gui") || stringArray[0].equals("-g")) {
                printTree.doGUITree(node);
            } else {
                printTree.doTextTree(node);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doGUITree(Node node) {
        DisplayTree displayTree = new DisplayTree();
        node.apply(displayTree);
        this.popup = this.createPopupMenuBar();
        this.frame = displayTree.getTreeFrame();
        PrintTree printTree = this;
        if (printTree == null) {
            throw null;
        }
        this.frame.addWindowListener(new WindowAdapter(printTree){
            private final /* synthetic */ PrintTree this$0;

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.this$0 = printTree;
                this.constructor$0(printTree);
            }

            private final void constructor$0(PrintTree printTree) {
            }
        });
        this.table = ((DisplayTree.TreeFrame)this.frame).getJTree();
        PrintTree printTree2 = this;
        if (printTree2 == null) {
            throw null;
        }
        this.table.addMouseListener(printTree2.new PopupListener());
        ((Component)this.frame).setVisible(true);
    }

    private void doTextTree(Node node) {
        node.apply(new PrintWalker());
    }

    private JPopupMenu createPopupMenuBar() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Set Native Look&Feel");
        PrintTree printTree = this;
        if (printTree == null) {
            throw null;
        }
        jMenuItem.addActionListener(new ActionListener(printTree){
            private final /* synthetic */ PrintTree this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception) {
                    System.out.println("Error setting Native LAF: " + exception);
                }
                SwingUtilities.updateComponentTreeUI(PrintTree.access$0(this.this$0));
            }
            {
                this.this$0 = printTree;
                this.constructor$0(printTree);
            }

            private final void constructor$0(PrintTree printTree) {
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Set Java Look&Feel");
        PrintTree printTree2 = this;
        if (printTree2 == null) {
            throw null;
        }
        jMenuItem2.addActionListener(new ActionListener(printTree2){
            private final /* synthetic */ PrintTree this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception exception) {
                    System.out.println("Error setting Java LAF: " + exception);
                }
                SwingUtilities.updateComponentTreeUI(PrintTree.access$0(this.this$0));
            }
            {
                this.this$0 = printTree;
                this.constructor$0(printTree);
            }

            private final void constructor$0(PrintTree printTree) {
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem("Set Motif Look&Feel");
        PrintTree printTree3 = this;
        if (printTree3 == null) {
            throw null;
        }
        jMenuItem3.addActionListener(new ActionListener(printTree3){
            private final /* synthetic */ PrintTree this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                }
                catch (Exception exception) {
                    System.out.println("Error setting Motif LAF: " + exception);
                }
                SwingUtilities.updateComponentTreeUI(PrintTree.access$0(this.this$0));
            }
            {
                this.this$0 = printTree;
                this.constructor$0(printTree);
            }

            private final void constructor$0(PrintTree printTree) {
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem("Quit");
        PrintTree printTree4 = this;
        if (printTree4 == null) {
            throw null;
        }
        jMenuItem4.addActionListener(new ActionListener(printTree4){
            private final /* synthetic */ PrintTree this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
            {
                this.this$0 = printTree;
                this.constructor$0(printTree);
            }

            private final void constructor$0(PrintTree printTree) {
            }
        });
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem4);
        return jPopupMenu;
    }

    static /* synthetic */ JFrame access$0(PrintTree printTree) {
        return printTree.frame;
    }

    private class PopupListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PrintTree.this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        PopupListener() {
        }
    }
}

