/* $Id: DerFormatException.java,v 1.1.1.1 2001/02/24 04:58:58 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.EncodingException;

/**
 * A subclass of <tt>EncodingException</tt> class (checked exception) to
 * denote that the parsed encoding violates a format rule of the type being
 * decoded.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class DerFormatException extends EncodingException {

	// Constants and vars
	// .......................................................................

	/**
	 * The ID of the ASN.1 UNIVERSAL type for which a format violation was
	 * detected.
	 */
	private int typeID;

	// Constructor(s)
	// .......................................................................

	/**
	 * Constructs a <tt>DerLengthMismatchException</tt> with no detail message.
	 *
	 * @param tagValue the ID of the ASN.1 UNIVERSAL type. It is the same value
	 * as that of the type's Tag value field instance; ie. that returned by the
	 * <tt>getValue()</tt> method when invoked on this element's Tag instance.
	 */
	public DerFormatException(int tagValue) {
		super("DER");

		this.typeID = tagValue;
	}

	// Instance methods
	// .......................................................................

	/**
	 * Returns an identifier of the UNIVERSAL type for which a format violation
	 * was detected.
	 *
	 * @return an ID of the type for which the format violation was detected.
	 */
	public int getTypeID() {
		return (this.typeID);
	}
}