/* $Id: DerInvalidTagValueException.java,v 1.1.1.1 2001/02/24 04:58:58 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.EncodingException;

/**
 * A subclass of <tt>EncodingException</tt> class (checked exception) to
 * denote that a decoding method for a specific ASN.1 UNIVERSAL type was
 * invoked with a Tag of a different value field; eg. a <tt>decodeBoolean(IType
 * obj)</tt> with the object's tag value different than <tt>Tag.BOOLEAN</tt>.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class DerInvalidTagValueException extends EncodingException {

	// Constants and vars
	// .......................................................................

	/**
	 * The expected Tag value.
	 */
	private int expectedTagValue;

	/**
	 * The value field of the Tag requested in the decode/read method.
	 */
	private int requestedTagValue;

	// Constructor(s)
	// .......................................................................

	/**
	 * Constructs a <tt>DerInvalidTagValueException</tt> with no detail message.
	 *
	 * @param xValue the known pre-determined Tag value field to find in the
	 * stream.
	 * @param rValue the value field of the requested Tag.
	 */
	public DerInvalidTagValueException(int xValue, int rValue) {
		super("DER");

		this.expectedTagValue = xValue;
		this.requestedTagValue = rValue;
	}

   // Instance methods
   // .......................................................................

	/**
	 * Returns the expected Tag value to find in the stream.
	 *
	 * @return the expected Tag value to find in the stream.
	 */
	public int getExpectedTagValue() {
		return (this.expectedTagValue);
	}

	/**
	 * Returns value field of the Tag requested in the decode/read method.
	 *
	 * @return value field of the Tag requested in the decode/read method.
	 */
	public int getRequestedTagValue() {
		return (this.requestedTagValue);
	}
}