/* $Id: DerLengthMismatchException.java,v 1.1.1.1 2001/02/24 04:58:58 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.EncodingException;

/**
 * A subclass of <tt>EncodingException</tt> class (checked exception) to
 * denote that the actual size of the data read from the stream (in number of
 * bytes) does not match the value parsed from the Length part of the DER
 * triplet.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class DerLengthMismatchException extends EncodingException {

	// Constants and vars
	// .......................................................................

	/**
	 * The expected length value. This is what got parsed in the Length part of
	 * the DER triplet.
	 */
	private int expectedLength;

	/**
	 * The actual number of bytes, constituting the size/length of the element
	 * itself.
	 */
	private int actualLength;

	// Constructor(s)
	// .......................................................................

	/**
	 * Constructs a <tt>DerLengthMismatchException</tt> with no detail message.
	 *
	 * @param aLength the actual (read) length value.
	 * @param xLength the expected (parsed from the Length part of the DER
	 * triplet) length value.
	 */
	public DerLengthMismatchException(int aLength, int xLength) {
		super("DER");

		this.actualLength = aLength;
		this.expectedLength = xLength;
	}

   // Instance methods
   // .......................................................................

	/**
	 * Returns the expected size in bytes of the element in the stream.
	 *
	 * @return the expected size of the element's encoding.
	 */
	public int getExpectedLength() {
		return (this.expectedLength);
	}

	/**
	 * Returns the actual size in bytes of the element in the stream.
	 *
	 * @return the actual size of the element's encoding.
	 */
	public int getActualLength() {
		return (this.actualLength);
	}
}