/* $Id: BlankElementException.java,v 1.1.1.1 2001/02/24 04:59:02 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.io;

/**
 * A subclass of ASNIOException class (checked exception) to denote that a
 * mandatory ASN.1 element, about to be encoded to a stream, was found to be
 * blank; ie. no value has been assigned to it yet.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class BlankElementException extends ASNIOException {

	/**
	 * Constructs a <tt>BlankElementException</tt> with the specified detail
	 * message. The error message string <tt>element</tt> can later be
	 * retrieved by the <tt>getMessage()</tt> method of class
	 * <tt>java.lang.Throwable</tt>.
	 *
	 * @param element the detail message, which in the case of this exception
	 * denotes the fully qualified class name of the ASN.1 element in question.
	 */
	public BlankElementException(String element) {
		super(element);
	}
}