/* $Id: Any.java,v 1.6 2001/05/26 07:10:24 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;

import org.apache.log4j.Category;

import java.io.IOException;
import java.io.EOFException;
import java.util.ArrayList;

/**
 * The basic implementation of the ASN.1 ANY type.<p>
 *
 * The value of such type is a concrete instance of a valid ASN.1 type.<p>
 *
 * @version $Revision: 1.6 $
 * @author  Raif S. Naffah
 */
public class Any extends Type implements IType {

	// Constants and vars
	// .......................................................................

	static Category cat = Category.getInstance(Any.class.getName());

	// Constructor(s)
	// .......................................................................

	/**
	 * Trivial constructor for a true ANY; ie. one with an unknown tag value
	 * at the moment of construction.
	 */
	public Any() {
		super("", null);
	}

	public Any(String name) {
		super(name, null);
	}

	public Any(String name, Tag tag) {
		super(name, tag);
	}

	public Any(String name, Tag tag, Object value) {
		super(name, tag);

		if (value != null)
			if (value instanceof IType)
				value(value);
//				setValue(((IType) value).getValue());
			else if (value instanceof ArrayList)
				value(value);
			else // should check if instance of byte[]
//				throw new ClassCastException();
//            setValue((byte[]) value);
            value(value);

		if (this.value != null)
			defaultValue(this.value);
	}

	// Class methods
	// .......................................................................

	/**
	 * Returns a new instance of this type with a trivial name and the
	 * designated value.
	 *
	 * @param value a designated concrete value for the new instance.
	 * @return a new instance with the designated value.
	 */
	public static Any getInstance(IType value) {
		return new Any("", null, value);
	}

	// Redefinition of methods in superclass Type
	// .......................................................................

	/**
	 * Decodes an instance of this object from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void decode(ASNReader is) throws IOException {
		String cn = this.getClass().getName();
		cat.debug("==> "+cn+".decode()");

		is.mark(Integer.MAX_VALUE);
		try {
			IType result = is.decodeAny(this.name());
			if (result == null)
				throw new ElementNotFoundException(cn);
			else {
				result.name(this.name());
				this.value(result);
			}
		} catch (IOException x) {
			cat.warn("Exception ("+String.valueOf(x)+") encountered while decoding a "+cn);
			if (x instanceof ASNException || x instanceof EOFException) {
				cat.warn("Resetting stream...");
				is.reset();
			}
			throw x;
		}

		cat.debug("<== "+cn+".decode()");
	}

	/**
	 * Encodes an instance of this object to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void encode(ASNWriter os) throws IOException {
		String cn = this.getClass().getName();
		cat.debug("==> "+cn+".encode()");

//      Object val = this.getValue();
		IType val = (IType) this.value();
		if (val != null)
//			os.encodeAny(this, val);
			val.encode(os);
		else {
//			val = this.getDefaultValue();
			val = (IType) this.defaultValue();
			if (val != null) {
				cat.warn("Encoding default value for "+cn);
//				os.encodeAny(this, val);
   			val.encode(os);
			} else if (!this.isOptional())
				throw new BlankElementException(cn);
//			else {
//				cat.warn("Encoding a NULL for "+cn);
//				new Null(this.name()).encode(os);
//			}
		}

		cat.debug("<== "+cn+".encode()");
	}

   // java.lang.Object overloaded methods
   // .......................................................................

	/**
	 * Returns a string representation of this instance.
	 *
	 * @return a string representation of this instance.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer("-- ");
		if (value != null)
			sb.append(String.valueOf(value));
		else
			sb.append("N/A");

		return sb.toString();
	}
}