/* $Id: IType.java,v 1.3 2001/05/24 16:52:49 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;

import java.io.IOException;
import java.io.Serializable;

/**
 * The visible methods of any ASN.1 type.<p>
 *
 * @version $Revision: 1.3 $
 * @author  Raif S. Naffah
 */
public interface IType extends Serializable {

	/**
	 * Return the user-defined Name of this ASN.1 object.
	 *
	 * @return the Name of this object.
	 */
	String name();

	/**
	 * Sets the user-defined Name of this ASN.1 object to the designated value.
	 *
	 * @param name the Name of this object.
	 */
	void name(String name);

	/**
	 * Returns the Tag instance of this object.
	 *
	 * @returns the Tag instance of this object.
	 */
	Tag tag();

	/**
	 * Decodes an instance of this object from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	void decode(ASNReader is) throws IOException;

	/**
	 * Encodes an instance of this object to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	void encode(ASNWriter os) throws IOException;

	/**
	 * Resets the current value of this instance to blank (initial value).
	 */
	void reset();

	/**
	 * Returns the current value of this instance.
	 *
	 * @return the current value of this instance.
	 */
	Object value();

	/**
	 * Sets the current value of this instance to the designated one.
	 *
	 * @param value the new value to assign to this instance.
	 */
	void value(Object value);

	/**
	 * Returns the default value of this instance.
	 *
	 * @return the default value of this instance.
	 */
	Object defaultValue();

	/**
	 * Sets the default value of this instance to the designated one.
	 *
	 * @param value the new default value to assign to this instance.
	 */
	void defaultValue(Object defaultValue);

	/**
	 * Returns true if this type --when used as a constituant of a compound type
	 * -- is optional or not.
	 *
	 * @return true if this type is optional; false otherwise.
	 */
	boolean isOptional();

	/**
	 * Sets the optional flag of this instance to the designated one.
	 *
	 * @param optional the new optional flag of this instance.
	 */
	void optional(boolean optional);

	/**
	 * Returns true if the value of this instance is not set.
	 *
	 * @return true if this instance's value is not set.
	 */
	boolean isBlank();
}