/* $Id: TestOfDefaultValues.java,v 1.1 2001/05/30 19:17:03 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

/**
 * Regression test for bug #428617.<p>
 *
 * DEFAULT values are not set/used properly.<p>
 *
 * @version $Revision: 1.1 $
 * @author  Raif S. Naffah
 */
public class TestOfDefaultValues extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

	SeqTypeF seq;
	byte[] data;
	ASNWriter der;
	ByteArrayOutputStream baos;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfDefaultValues(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfDefaultValues.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testDecodeDefaults1() {
      try {
         makeData();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeF seq = new SeqTypeF();

   		der.open(new ByteArrayInputStream(data));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getX().booleanValue().equals(Boolean.TRUE));
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testDecodeDefaults2() {
      try {
         makeData();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeF seq = new SeqTypeF();

   		der.open(new ByteArrayInputStream(data));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getB().booleanValue().equals(Boolean.TRUE));
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testDecodeDefaults3() {
      try {
         makeData();

   		ASNReader der = Factory.getDecoder("DER");
   		SeqTypeF seq = new SeqTypeF();

   		der.open(new ByteArrayInputStream(data));
   		seq.decode(der);
   		der.close();

   		assertTrue(seq.getV().intValue().compareTo(new BigInteger("2")) == 0);
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	protected void setUp() throws Exception {
	   der = Factory.getEncoder("DER");
	   baos = new ByteArrayOutputStream();

		seq = new SeqTypeF("sequence");
      seq.setX(ASNBoolean.getInstance(true));
	}

	private void makeData() throws Exception {
      baos.reset();
      der.open(baos);
      seq.encode(der);
      der.close();
      data = baos.toByteArray();
   }
}