/* $Id: TestOfOIDEncoding.java,v 1.1 2001/06/02 02:46:40 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * Regression test for bug #425201.
 *
 * Ensures that definite length OIDs, when DER encoded, conform strictly to pp.
 * 17-18, section. 8.19 of X.690 standard --ISO/IEC IS 8825-1, July 1994.<p>
 *
 * @version $Revision: 1.1 $
 * @author  Raif S. Naffah, Axelle Apvrille
 */
public class TestOfOIDEncoding extends TestCase {

	// Constants and variables
	// -------------------------------------------------------------------------

   private static final byte[] OID1 = { 0x06, 0x03, (byte) 0x81, 0x34, 0x03 };
   private static final byte[] OID2 = { 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A };

	ASNWriter der;
	ByteArrayOutputStream baos;

	// Constructor(s)
	// -------------------------------------------------------------------------

	public TestOfOIDEncoding(String name) {
		super(name);
	}

	// Class methods
	// -------------------------------------------------------------------------

	public static void main(String[] args) {
		TestRunner.run(suite());
	}

	public static Test suite() {
		return new TestSuite(TestOfOIDEncoding.class);
	}

	// Instance methods
	// -------------------------------------------------------------------------

	public void testOIDParsing1() {
      ObjectIdentifier oid = Module.instance().getOID("oidTypeA");
      assertTrue("2.100.3".equals(oid.stringValue()));
	}

	public void testDerEncodeOID1() {
      try {
         ObjectIdentifier oid = Module.instance().getOID("oidTypeA");
         baos.reset();

         der.open(baos);
         oid.encode(der);
         der.close();

   		assertTrue(sameValue(OID1, baos.toByteArray()));
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	public void testOIDParsing2() {
      ObjectIdentifier oid = Module.instance().getOID("oidTypeB");
      assertTrue("1.3.14.3.2.26".equals(oid.stringValue()));
	}

	public void testDerEncodeOID2() {
      try {
         ObjectIdentifier oid = Module.instance().getOID("oidTypeB");
         baos.reset();

         der.open(baos);
         oid.encode(der);
         der.close();

   		assertTrue(sameValue(OID2, baos.toByteArray()));
      } catch (Exception x) {
         x.printStackTrace();
         fail();
      }
	}

	protected void setUp() throws Exception {
	   der = Factory.getEncoder("DER");
	   baos = new ByteArrayOutputStream();
	}

   private static boolean sameValue(byte[] b1, byte[] b2) {
      if (b1 == null || b2 == null)
         return false;

      System.err.println();
      System.err.println("*** b1=0x"+new BigInteger(1, b1).toString(16));
      System.err.println("*** b2=0x"+new BigInteger(1, b2).toString(16));
      if (b1.length != b2.length)
         return false;

      for (int i = 0; i < b1.length; i++)
         if (b1[i] != b2[i])
            return false;

      return true;
   }
}