/* $Id: TestXer.java,v 1.4 2001/06/30 01:54:53 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package test;

import cryptix.asn1.encoding.*;
import cryptix.asn1.io.*;
import cryptix.asn1.lang.*;

// IMPORTANT: this package is what will get generated by the Main tools class.
// Do not attempt to compile this class before cryptix.asn1.tools.Main has
// exited successfully. In addition, a -P option should be specified when
// invoking the Main tools class to map CryptixUsefulDefinitions (the ASN.1
// module name defined in 'cryptix.asn' definitions file to the following
// package name; eg. -PCryptixUsefulDefinitions=cryptix.asn1.common. For how
// to work this out in an automated way, see the Makefile.
import cryptix.asn1.common.*;

import org.apache.log4j.Category;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.GregorianCalendar;

/**
 * A test class to exercise, already generated, Java ASN.1 classes with a DER
 * decoder and XER encoder.<p>
 *
 * @version $Revision: 1.4 $
 * @author  Raif S. Naffah
 */
public class TestXer {

	private static Category cat = Category.getInstance(TestXer.class);

	public static final void main(String[] args) throws Exception {
		cat.info("");
		cat.info("-------------------------------------------------------");
		cat.info("Test XER");
		cat.info("-------------------------------------------------------");
		cat.info("");

		if (args.length < 1) {
			cat.info("Usage:");
			cat.info("  java test.TestXer <encoding>");
			System.exit(1);
		}

		File f = new File(args[0]);
		if (!f.isFile()) {
			cat.error("File "+f.getAbsolutePath()+" does not exist");
			System.exit(2);
		}

		String data = f.getAbsolutePath();

		cat.info("Can we access \""+data+"\" ?");
		FileInputStream fis = null;
		try {
			fis = new FileInputStream(f);
		} catch (FileNotFoundException e) {
			cat.error("File "+f.getAbsolutePath()+" does not exist");
			System.exit(3);
		}

		cat.info("Yes...");

		cat.info("");
		cat.info("Can we access the x509 instance present inside?");

		ASNReader der = Factory.getDecoder("DER");
		if (der == null) {
			cat.error("Unable to instantiate a DER Decoder");
			System.exit(4);
		}

		cat.info("Yes...");
		Certificate x509 = new Certificate();

		der.open(fis); // prepare for decoding
		x509.decode(der);
		der.close();

		cat.info(String.valueOf(x509));

		cat.info("");
		cat.info("Done decoding tests...");
		cat.info("");

		cat.info("Begin encoding tests...");

		FileOutputStream f1 = new FileOutputStream("./anX509.xer");
		ASNWriter dos = Factory.getEncoder("XER");

		dos.open(f1);
		x509.encode(dos);
		dos.close();

		// NOTE: you should have a security provider for RSA (both keypair
		// generations and signature) already installed at this point.
		// the following code assumes it is the case.

		// generating an RSA keypair
		KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
		kpg.initialize(1024);
		KeyPair kp = kpg.generateKeyPair();
		PublicKey pubK = kp.getPublic();
		PrivateKey privK = kp.getPrivate();

		cat.info("Manufacturing a CertificateInfo...");
		AlgorithmIdentifier scheme = new AlgorithmIdentifier();
		scheme.setAlgorithm(ObjectIdentifier.getInstance(("1.2.840.113549.1.1.4"))); // md5WithRSAEncryption

		Validity validity = new Validity();
		validity.setNotBefore(UTCTime.getInstance((new GregorianCalendar(2000, 11,  1).getTime())));
		validity.setNotAfter(UTCTime.getInstance((new GregorianCalendar(2001, 10, 30).getTime())));

		SubjectPublicKeyInfo sKInfo = new SubjectPublicKeyInfo();
		AlgorithmIdentifier pkix = new AlgorithmIdentifier();
		pkix.setAlgorithm(ObjectIdentifier.getInstance(("1.2.840.113549.1.1.1"))); // rsaEncryption
		sKInfo.setAlgorithm(pkix);
		sKInfo.setSubjectPublicKey(BitString.getInstance((pubK.getEncoded())));

		CertificateInfo info = new CertificateInfo(); // use default value for Version!
		info.setSerialNumber(new CertificateSerialNumber(ASNInteger.getInstance((100))));
		info.setSignature(scheme);
		info.setIssuer(self());
		info.setValidity(validity);
		info.setSubject(self());
		info.setSubjectPublicKeyInfo(sKInfo);

		cat.info("cert-info="+String.valueOf(info));

		// sign it
		cat.info("Signing the CertificateInfo instance...");
		ByteArrayOutputStream baos = new ByteArrayOutputStream();

		dos.open(baos);
		info.encode(dos);
		dos.close();

		byte[] toSign = baos.toByteArray();

		Signature sigMaker = Signature.getInstance("MD5withRSA");

		sigMaker.initSign(privK);
		sigMaker.update(toSign);
		byte[] signed = sigMaker.sign();

		cat.info("Assembling the certificate...");
		Certificate cert = new Certificate();
		cert.setCertificateInfo(info);
		cert.setSignatureAlgorithm(scheme);
		cert.setSignature(BitString.getInstance((signed)));

		cat.info("cert="+String.valueOf(cert));

		cat.info("XER encoding the certificate...");
		baos = new ByteArrayOutputStream();
		dos.open(baos);
		cert.encode(dos);
		dos.close();

		cat.info("");
		cat.info("Done encoding tests...");
	}

	private static final Name self() {
		Name result = new Name();

		RelativeDistinguishedName rdn1 = new RelativeDistinguishedName();
		AttributeValueAssertion cn = new AttributeValueAssertion();
		cn.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.3"))));
		cn.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("Forge Research Pty. Limited"))));
		rdn1.iterator().add(cn);
		result.iterator().add(rdn1);

		RelativeDistinguishedName rdn2 = new RelativeDistinguishedName();
		AttributeValueAssertion unit = new AttributeValueAssertion();
		unit.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.11"))));
		unit.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("Sydney"))));
		rdn2.iterator().add(unit);
		result.iterator().add(rdn2);

		RelativeDistinguishedName rdn3 = new RelativeDistinguishedName();
		AttributeValueAssertion org = new AttributeValueAssertion();
		org.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.10"))));
		org.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("Forge IT"))));
		rdn3.iterator().add(org);
		result.iterator().add(rdn3);

		RelativeDistinguishedName rdn4 = new RelativeDistinguishedName();
		AttributeValueAssertion ava4 = new AttributeValueAssertion();
		ava4.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.7"))));
		ava4.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("Forge CEO"))));
		rdn4.iterator().add(ava4);
		result.iterator().add(rdn4);

		RelativeDistinguishedName rdn5 = new RelativeDistinguishedName();
		AttributeValueAssertion ava5 = new AttributeValueAssertion();
		ava5.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.8"))));
		ava5.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("NSW"))));
		rdn5.iterator().add(ava5);
		result.iterator().add(rdn5);

		RelativeDistinguishedName rdn6 = new RelativeDistinguishedName();
		AttributeValueAssertion country = new AttributeValueAssertion();
		country.setAttributeType(
			new AttributeType(ObjectIdentifier.getInstance(("2.5.4.6"))));
		country.setAttributeValue(
			new AttributeValue(PrintableString.getInstance(("Australia"))));
		rdn6.iterator().add(country);
		result.iterator().add(rdn6);

		return result;
	}
}