/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.lang.IIterativeType;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class DerEncoder
extends ASNWriter
implements Cloneable {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$encoding$DerEncoder != null ? class$Lcryptix$asn1$encoding$DerEncoder : (class$Lcryptix$asn1$encoding$DerEncoder = DerEncoder.class$("cryptix.asn1.encoding.DerEncoder"))).getName());
    BufferedOutputStream out;
    private static /* synthetic */ Class class$Lcryptix$asn1$encoding$DerEncoder;

    public Object clone() {
        return new DerEncoder();
    }

    public void open(OutputStream outputStream) {
        if (this.out != null) {
            throw new IllegalStateException();
        }
        this.out = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 10240);
    }

    public void encodeAny(IType iType, Object object) throws IOException {
        cat.debug((Object)"==> encodeAny()");
        if (object instanceof Boolean) {
            this.encodeBoolean(iType, (Boolean)object);
        } else if (object instanceof BigInteger) {
            this.encodeInteger(iType, (BigInteger)object);
        } else if (object instanceof String) {
            this.encodeString(28, iType, (String)object);
        } else if (object instanceof Date) {
            this.encodeUTCTime(iType, (Date)object);
        } else if (object instanceof IType) {
            ((IType)object).encode(this);
        } else {
            this.encodeOctetString(iType, (byte[])object);
        }
        cat.debug((Object)"<== encodeAny()");
    }

    public void encodeObjectIdentifier(IType iType, String string) throws IOException {
        cat.debug((Object)"==> encodeObjectIdentifier()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=\"" + string + "\""));
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        n = 2;
        while (n < nArray.length) {
            int n2 = nArray[n];
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[1] = 0;
            byArray[0] = 0;
            int n3 = 0;
            while (n3 < 4) {
                byArray[n3] = (byte)(n2 & 0x7F);
                if ((n2 >>>= 7) == 0) break;
                ++n3;
            }
            while (n3 > 0) {
                byteArrayOutputStream.write(byArray[n3] | 0x80);
                --n3;
            }
            byteArrayOutputStream.write(byArray[0]);
            ++n;
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray2 = this.toTLV(6, byArray2);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray2.length);
            this.write(byArray2);
            this.flush();
        }
        cat.debug((Object)"<== encodeObjectIdentifier()");
    }

    public void encodeNull(IType iType) throws IOException {
        cat.debug((Object)"==> encodeNull()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        byte[] byArray = new byte[]{};
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(5, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeNull()");
    }

    public void encodeBoolean(IType iType, Boolean bl) throws IOException {
        cat.debug((Object)"==> encodeBoolean()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=" + String.valueOf(bl)));
        byte[] byArray = new byte[]{(byte)(bl != false ? 1 : 0)};
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(1, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeBoolean()");
    }

    public void encodeInteger(IType iType, BigInteger bigInteger) throws IOException {
        cat.debug((Object)"==> encodeInteger()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=" + String.valueOf(bigInteger)));
        byte[] byArray = bigInteger.toByteArray();
        if ((byArray[0] & 0x80) != 0) {
            throw new IllegalArgumentException("Illegal internal encoding");
        }
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(2, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeInteger()");
    }

    public void encodeString(int n, IType iType, String string) throws IOException {
        cat.debug((Object)("==> encodeString(" + n + ")"));
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=" + String.valueOf(string)));
        byte[] byArray = string.getBytes("UTF8");
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(n, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeString()");
    }

    public void encodeBitString(IType iType, byte[] byArray) throws IOException {
        cat.debug((Object)"==> encodeBitString()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray2 = this.toTLV(3, byArray2);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray2.length);
            this.write(byArray2);
            this.flush();
        }
        cat.debug((Object)"<== encodeBitString()");
    }

    public void encodeOctetString(IType iType, byte[] byArray) throws IOException {
        cat.debug((Object)"==> encodeOctetString()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(4, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeOctetString()");
    }

    public void encodeUTCTime(IType iType, Date date) throws IOException {
        cat.debug((Object)"==> encodeUTCTime()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=" + String.valueOf(date)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(23, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeUTCTime()");
    }

    public void encodeGeneralizedTime(IType iType, Date date) throws IOException {
        cat.debug((Object)"==> encodeGeneralizedTime()");
        Tag tag = iType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        cat.info((Object)("   val=" + String.valueOf(date)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'.'SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] byArray = simpleDateFormat.format(date).getBytes();
        if (tag.isExplicit() && !tag.isUniversal()) {
            byArray = this.toTLV(24, byArray);
        }
        BufferedOutputStream bufferedOutputStream = this.out;
        synchronized (bufferedOutputStream) {
            this.encode(tag);
            this.encode(byArray.length);
            this.write(byArray);
            this.flush();
        }
        cat.debug((Object)"<== encodeGeneralizedTime()");
    }

    public void encodeStructure(IIterativeType iIterativeType) throws IOException {
        Object object;
        cat.debug((Object)"==> encodeStructure()");
        Tag tag = iIterativeType.getTag();
        cat.info((Object)("   tag=\"" + tag + "\""));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASNWriter aSNWriter = (ASNWriter)this.clone();
        aSNWriter.open(byteArrayOutputStream);
        Object object2 = iIterativeType.iterator();
        while (object2.hasNext()) {
            object = (Type)object2.next();
            cat.info((Object)("Encoding " + object.getClass().getName() + "..."));
            object.encode(aSNWriter);
        }
        aSNWriter.close();
        object2 = byteArrayOutputStream.toByteArray();
        if (tag.isExplicit() && !tag.isUniversal()) {
            object2 = this.toTLV(16, (byte[])object2);
        }
        object = this.out;
        synchronized (object) {
            this.encode(tag);
            this.encode(((Object)object2).length);
            this.write((byte[])object2);
            this.flush();
        }
        cat.debug((Object)"<== encodeStructure()");
    }

    public void write(int n) throws IOException {
        this.out.write(n & 0xFF);
    }

    public void close() throws IOException {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                cat.warn((Object)("I/O exception while closing the stream: " + iOException.getMessage()));
            }
            this.out = null;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    private void encode(Tag tag) throws IOException {
        int n;
        int n2 = tag.getClazz();
        if (tag.isConstructed()) {
            n2 |= 0x20;
        }
        if ((n = tag.getValue()) < 31) {
            this.write(n2 | n);
        } else {
            this.write(n2 | 0x1F);
            n2 = n;
            while (n2 > 63) {
                this.write(63);
                n2 -= 63;
            }
            this.write(n2);
        }
    }

    private void encode(int n) throws IOException {
        if (n < 128) {
            this.write(n);
            return;
        }
        if (n < 256) {
            this.write(-127);
            this.write(n);
            return;
        }
        if (n < 65536) {
            this.write(-126);
            this.write(n >> 8);
            this.write(n);
            return;
        }
        if (n < 0x1000000) {
            this.write(-125);
            this.write(n >> 16);
            this.write(n >> 8);
            this.write(n);
            return;
        }
        this.write(-124);
        this.write(n >> 24);
        this.write(n >> 16);
        this.write(n >> 8);
        this.write(n);
    }

    private byte[] toTLV(int n, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DerEncoder derEncoder = new DerEncoder();
        derEncoder.open(byteArrayOutputStream);
        derEncoder.encode(new Tag(n));
        derEncoder.encode(byArray.length);
        derEncoder.write(byArray);
        derEncoder.close();
        return byteArrayOutputStream.toByteArray();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

