/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.lang.IIterativeType;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Type;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class XerEncoder
extends ASNWriter
implements Cloneable {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$encoding$XerEncoder != null ? class$Lcryptix$asn1$encoding$XerEncoder : (class$Lcryptix$asn1$encoding$XerEncoder = XerEncoder.class$("cryptix.asn1.encoding.XerEncoder"))).getName());
    private static final String INDENTATION = "   ";
    protected PrintWriter out;
    protected int level;
    private static /* synthetic */ Class class$Lcryptix$asn1$encoding$XerEncoder;

    public Object clone() {
        return new XerEncoder();
    }

    public void open(OutputStream outputStream) {
        if (this.out != null) {
            throw new IllegalStateException();
        }
        this.out = outputStream instanceof BufferedOutputStream ? new PrintWriter(outputStream, true) : new PrintWriter(new BufferedOutputStream(outputStream, 10240), true);
        this.level = 0;
    }

    public void encodeAny(IType iType, Object object) throws IOException {
        cat.debug((Object)"==> encodeAny()");
        if (object instanceof Boolean) {
            this.encodeBoolean(iType, (Boolean)object);
        } else if (object instanceof BigInteger) {
            this.encodeInteger(iType, (BigInteger)object);
        } else if (object instanceof String) {
            this.encodeString(28, iType, (String)object);
        } else if (object instanceof Date) {
            this.encodeUTCTime(iType, (Date)object);
        } else if (object instanceof IType) {
            ((IType)object).encode(this);
        } else {
            this.encodeOctetString(iType, (byte[])object);
        }
        cat.debug((Object)"<== encodeAny()");
    }

    public void encodeObjectIdentifier(IType iType, String string) throws IOException {
        cat.debug((Object)"==> encodeObjectIdentifier()");
        String string2 = iType.getName();
        cat.info((Object)("   name=\"" + string2 + "\""));
        cat.info((Object)("   val=\"" + string + "\""));
        if (string2 == null || string2.equals("")) {
            string2 = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string2).append(">").append(string).append("</").append(string2).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeObjectIdentifier()");
    }

    public void encodeNull(IType iType) throws IOException {
        cat.debug((Object)"==> encodeNull()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append("/>");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeNull()");
    }

    public void encodeBoolean(IType iType, Boolean bl) throws IOException {
        cat.debug((Object)"==> encodeBoolean()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        cat.info((Object)("   val=" + String.valueOf(bl)));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append(bl.toString()).append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeBoolean()");
    }

    public void encodeInteger(IType iType, BigInteger bigInteger) throws IOException {
        cat.debug((Object)"==> encodeInteger()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        cat.info((Object)("   val=" + String.valueOf(bigInteger)));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append(bigInteger.toString()).append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeInteger()");
    }

    public void encodeString(int n, IType iType, String string) throws IOException {
        cat.debug((Object)("==> encodeString(" + n + ")"));
        String string2 = iType.getName();
        cat.info((Object)("   name=\"" + string2 + "\""));
        cat.info((Object)("   val=" + String.valueOf(string)));
        if (string2 == null || string2.equals("")) {
            string2 = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.level) {
            stringBuffer.append(INDENTATION);
            ++n2;
        }
        stringBuffer.append("<").append(string2).append(">").append(string).append("</").append(string2).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeString()");
    }

    public void encodeBitString(IType iType, byte[] byArray) throws IOException {
        cat.debug((Object)"==> encodeBitString()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append(new BigInteger(1, byArray).toString(2)).append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeBitString()");
    }

    public void encodeOctetString(IType iType, byte[] byArray) throws IOException {
        cat.debug((Object)"==> encodeOctetString()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append("<Hex>").append(new BigInteger(1, byArray).toString(16)).append("</Hex>").append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeOctetString()");
    }

    public void encodeUTCTime(IType iType, Date date) throws IOException {
        cat.debug((Object)"==> encodeUTCTime()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        cat.info((Object)("   val=" + String.valueOf(date)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append(simpleDateFormat.format(date)).append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeUTCTime()");
    }

    public void encodeGeneralizedTime(IType iType, Date date) throws IOException {
        cat.debug((Object)"==> encodeGeneralizedTime()");
        String string = iType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        cat.info((Object)("   val=" + String.valueOf(date)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.sss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.level) {
            stringBuffer.append(INDENTATION);
            ++n;
        }
        stringBuffer.append("<").append(string).append(">").append(simpleDateFormat.format(date)).append("</").append(string).append(">");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.out.println(stringBuffer.toString());
        }
        cat.debug((Object)"<== encodeGeneralizedTime()");
    }

    public void encodeStructure(IIterativeType iIterativeType) throws IOException {
        cat.debug((Object)"==> encodeStructure()");
        String string = iIterativeType.getName();
        cat.info((Object)("   name=\"" + string + "\""));
        if (string == null || string.equals("")) {
            string = "Name";
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.level) {
                stringBuffer.append(INDENTATION);
                ++n;
            }
            String string2 = stringBuffer.toString();
            ++this.level;
            this.out.println(string2 + "<" + string + ">");
            ListIterator listIterator = iIterativeType.iterator();
            while (listIterator.hasNext()) {
                Serializable serializable;
                Object e = listIterator.next();
                if (e instanceof IType) {
                    serializable = (Type)e;
                    cat.info((Object)("Encoding " + serializable.getClass().getName() + "..."));
                    serializable.encode(this);
                    continue;
                }
                if (e instanceof ArrayList) {
                    serializable = (ArrayList)e;
                    cat.info((Object)"Encoding a SEQUENCE/SET OF...");
                    this.encodeStructureInternal(((AbstractList)((Object)serializable)).iterator());
                    continue;
                }
                throw new RuntimeException("Dont know how to encode a " + iIterativeType.getClass().getName());
            }
            this.out.println(string2 + "</" + string + ">");
            --this.level;
        }
        cat.debug((Object)"<== encodeStructure()");
    }

    public void encodeStructureInternal(Iterator iterator) throws IOException {
        cat.debug((Object)"==> encodeStructureInternal()");
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            while (iterator.hasNext()) {
                Serializable serializable;
                Object e = iterator.next();
                if (e instanceof IType) {
                    serializable = (Type)e;
                    cat.info((Object)("Encoding " + serializable.getClass().getName() + "..."));
                    serializable.encode(this);
                    continue;
                }
                if (e instanceof ArrayList) {
                    serializable = (ArrayList)e;
                    cat.info((Object)"Encoding a SEQUENCE/SET OF...");
                    this.encodeStructureInternal(((AbstractList)((Object)serializable)).iterator());
                    continue;
                }
                throw new RuntimeException("Dont know how to encode a " + e.getClass().getName());
            }
        }
        cat.debug((Object)"<== encodeStructureInternal()");
    }

    public void write(int n) throws IOException {
        this.out.write(n & 0xFF);
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

