/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Null;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.log4j.Category;

public class ASNInteger
extends Type
implements IType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$ASNInteger != null ? class$Lcryptix$asn1$lang$ASNInteger : (class$Lcryptix$asn1$lang$ASNInteger = ASNInteger.class$("cryptix.asn1.lang.ASNInteger"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$ASNInteger;

    public static ASNInteger getInstance(String string) {
        return new ASNInteger("", new BigInteger(string));
    }

    public static ASNInteger getInstance(BigInteger bigInteger) {
        return new ASNInteger("", bigInteger);
    }

    public static ASNInteger getInstance(long l) {
        return new ASNInteger("", BigInteger.valueOf(l));
    }

    public static ASNInteger getInstance(ASNInteger aSNInteger) {
        return new ASNInteger("", aSNInteger);
    }

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        aSNReader.mark(Integer.MAX_VALUE);
        try {
            BigInteger bigInteger = aSNReader.decodeInteger(this);
            if (bigInteger == null) {
                throw new ElementNotFoundException(string);
            }
            this.setValue(bigInteger);
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void encode(ASNWriter aSNWriter) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encode()"));
        Object object = this.getValue();
        if (object != null) {
            aSNWriter.encodeInteger(this, (BigInteger)object);
        } else {
            object = this.getDefaultValue();
            if (object != null) {
                cat.warn((Object)("Encoding default value for " + string));
                aSNWriter.encodeInteger(this, (BigInteger)object);
            } else {
                if (!this.isOptional()) {
                    throw new BlankElementException(string);
                }
                cat.warn((Object)("Encoding a NULL for " + string));
                new Null(this.getName()).encode(aSNWriter);
            }
        }
        cat.debug((Object)("<== " + string + ".encode()"));
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.value = new BigInteger((String)object);
        } else if (object instanceof BigInteger) {
            this.value = (BigInteger)object;
        } else if (object instanceof ASNInteger) {
            this.value = ((ASNInteger)object).intValue();
        } else {
            throw new ClassCastException();
        }
    }

    public BigInteger intValue() {
        return (BigInteger)this.value;
    }

    protected boolean sameValue(Object object) {
        if (object == null || !(object instanceof BigInteger)) {
            return false;
        }
        BigInteger bigInteger = this.intValue();
        return bigInteger == null ? false : bigInteger.compareTo(object) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        if (this.value != null) {
            BigInteger bigInteger = this.intValue();
            stringBuffer.append(bigInteger.toString());
            stringBuffer.append(" [0x").append(bigInteger.toString(16)).append("]");
        } else {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ASNInteger() {
        super("", new Tag(2));
    }

    public ASNInteger(String string) {
        super(string, new Tag(2));
    }

    public ASNInteger(String string, Tag tag) {
        super(string, tag);
    }

    public ASNInteger(String string, Object object) {
        this(string, new Tag(2), object);
    }

    public ASNInteger(String string, Tag tag, Object object) {
        super(string, tag);
        this.setValue(object);
        if (this.value != null) {
            this.setDefaultValue(this.value);
        }
    }
}

