/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Null;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Category;

public abstract class ASNString
extends Type
implements IType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$ASNString != null ? class$Lcryptix$asn1$lang$ASNString : (class$Lcryptix$asn1$lang$ASNString = ASNString.class$("cryptix.asn1.lang.ASNString"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$ASNString;

    public abstract void decode(ASNReader var1) throws IOException;

    public abstract void encode(ASNWriter var1) throws IOException;

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.value = (String)object;
        } else if (object instanceof ASNString) {
            this.value = ((ASNString)object).stringValue();
        } else {
            throw new ClassCastException();
        }
    }

    public String stringValue() {
        return (String)this.value;
    }

    protected boolean sameValue(Object object) {
        String string = this.stringValue();
        return string == null ? false : string.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        if (this.value != null) {
            stringBuffer.append("\"").append(this.stringValue()).append("\"");
        } else {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    void decodeInternal(ASNReader aSNReader, int n) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decodeInternal(" + n + ")"));
        aSNReader.mark(Integer.MAX_VALUE);
        try {
            String string2 = aSNReader.decodeString(n, this);
            if (string2 == null) {
                throw new ElementNotFoundException(string);
            }
            this.setValue(string2);
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        cat.debug((Object)("<== " + string + ".decodeInternal()"));
    }

    void encodeInternal(ASNWriter aSNWriter, int n) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encodeInternal(" + n + ")"));
        Object object = this.getValue();
        if (object != null) {
            aSNWriter.encodeString(n, this, (String)object);
        } else {
            object = this.getDefaultValue();
            if (object != null) {
                cat.warn((Object)("Encoding default value for " + string));
                aSNWriter.encodeString(n, this, (String)object);
            } else {
                if (!this.isOptional()) {
                    throw new BlankElementException(string);
                }
                cat.warn((Object)("Encoding a NULL for " + string));
                new Null(this.getName()).encode(aSNWriter);
            }
        }
        cat.debug((Object)("<== " + string + ".encodeInternal()"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ASNString(String string, Tag tag) {
        super(string, tag);
    }
}

