/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Set;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.log4j.Category;

public abstract class Choice
extends Set {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$Choice != null ? class$Lcryptix$asn1$lang$Choice : (class$Lcryptix$asn1$lang$Choice = Choice.class$("cryptix.asn1.lang.Choice"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$Choice;

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        this.reset();
        aSNReader.mark(Integer.MAX_VALUE);
        boolean bl = false;
        cat.info((Object)"Looking for a valid ASN.1 alternative for a CHOICE.");
        try {
            IType iType = aSNReader.decodeAny("choice");
            ListIterator listIterator = this.iterator();
            while (listIterator.hasNext()) {
                Type type = (Type)listIterator.next();
                bl = type.getTag().equals(iType.getTag());
                if (!bl) continue;
                cat.info((Object)("Found a " + type.getClass().getName()));
                type.setValue(iType.getValue());
                break;
            }
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        if (!bl) {
            throw new ASNException("No valid alternative for " + string + " (CHOICE) was found...");
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void encode(ASNWriter aSNWriter) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encode()"));
        boolean bl = false;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Type type = (Type)listIterator.next();
            boolean bl2 = bl = !type.isBlank();
            if (!bl) continue;
            cat.info((Object)("Encoding " + type.getClass().getName() + "..."));
            type.encode(aSNWriter);
            break;
        }
        if (!bl) {
            throw new BlankElementException(string);
        }
        cat.debug((Object)("<== " + string + ".encode()"));
    }

    public Object getValue() {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".getValue()"));
        IType iType = null;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType2 = (IType)listIterator.next();
            if (iType2.isBlank()) continue;
            iType = iType2;
            break;
        }
        cat.debug((Object)("<== " + string + ".getValue() --> " + String.valueOf(iType)));
        return iType;
    }

    public void setValue(Object object) {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".setValue(" + String.valueOf(object) + ")"));
        this.reset();
        IType iType = (IType)object;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType2 = (IType)listIterator.next();
            if (!iType2.getTag().equals(iType.getTag())) continue;
            cat.debug((Object)("Assigning " + String.valueOf(iType) + " to " + String.valueOf(iType2)));
            iType2.setValue(iType.getValue());
            break;
        }
        cat.debug((Object)("<== " + string + ".setValue()"));
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("-- Begin ").append(string).append(" (CHOICE)").append(string2);
        int n = 1;
        boolean bl = false;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Type type = (Type)listIterator.next();
            boolean bl2 = bl = !type.isBlank();
            if (bl) {
                stringBuffer.append("--   alternative #").append(n).append(" (").append(type.getClass().getName()).append("): ").append(String.valueOf(type)).append(string2);
                break;
            }
            ++n;
        }
        if (!bl) {
            stringBuffer.append("--   N/A").append(string2);
        }
        stringBuffer.append("-- End ").append(string).append(" (CHOICE)");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Choice(Tag tag) {
        super("", tag);
    }

    public Choice(String string, Tag tag) {
        super(string, tag);
    }

    public Choice(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            if (object instanceof ArrayList) {
                this.setValue(object);
            } else {
                throw new ClassCastException();
            }
        }
    }
}

