/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.CompoundType;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.log4j.Category;

public abstract class Sequence
extends CompoundType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$Sequence != null ? class$Lcryptix$asn1$lang$Sequence : (class$Lcryptix$asn1$lang$Sequence = Sequence.class$("cryptix.asn1.lang.Sequence"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$Sequence;

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        this.reset();
        aSNReader.mark(Integer.MAX_VALUE);
        ASNReader aSNReader2 = aSNReader.decodeStructure(this);
        if (aSNReader2 == null) {
            cat.warn((Object)(string + " not found. Backtracking..."));
            aSNReader.reset();
            throw new ElementNotFoundException(string);
        }
        cat.info((Object)("Iterating through " + string + "'s components..."));
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            Type type = (Type)listIterator.next();
            try {
                cat.info((Object)("Looking for " + type.getClass().getName()));
                type.decode(aSNReader2);
                cat.info((Object)("Found " + type.getClass().getName()));
            }
            catch (ElementNotFoundException elementNotFoundException) {
                if (!type.isOptional()) {
                    cat.warn((Object)(String.valueOf(elementNotFoundException) + ". Backtracking..."));
                    aSNReader.reset();
                    throw elementNotFoundException;
                }
                cat.warn((Object)(String.valueOf(elementNotFoundException) + ". Ignoring..."));
            }
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void reset() {
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            ((IType)listIterator.next()).reset();
        }
    }

    public Object getValue() {
        return this.cloneComponents();
    }

    public void setValue(Object object) {
        this.reset();
        Iterator iterator = ((AbstractList)((ArrayList)object)).iterator();
        ListIterator listIterator = this.iterator();
        while (iterator.hasNext() && listIterator.hasNext()) {
            IType iType = (IType)iterator.next();
            IType iType2 = (IType)listIterator.next();
            cat.info((Object)("Assigning value from " + iType.getClass().getName() + " to " + iType2.getClass().getName()));
            iType2.setValue(iType.getValue());
        }
    }

    public boolean isBlank() {
        boolean bl = true;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType = (IType)listIterator.next();
            if (iType.isBlank()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public ListIterator iterator() {
        return ((AbstractList)this.components).listIterator();
    }

    protected void initInternal() {
        super.initInternal();
        this.value = null;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append("-- Begin ").append(string).append(" (SEQUENCE)").append(string2);
        int n = 1;
        ListIterator listIterator = this.iterator();
        while (listIterator.hasNext()) {
            IType iType = (IType)listIterator.next();
            stringBuffer.append("--   field #").append(n++).append(" (").append(iType.getClass().getName()).append("): ").append(String.valueOf(iType)).append(string2);
        }
        stringBuffer.append("-- End ").append(string).append(" (SEQUENCE)");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Sequence(Tag tag) {
        super("", tag);
    }

    public Sequence(String string, Tag tag) {
        super(string, tag);
    }

    public Sequence(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            if (object instanceof ArrayList) {
                this.setValue(object);
            } else {
                throw new ClassCastException();
            }
        }
    }
}

