/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.tools;

import cryptix.asn1.lexer.Lexer;
import cryptix.asn1.node.Node;
import cryptix.asn1.node.Start;
import cryptix.asn1.node.Switch;
import cryptix.asn1.parser.Parser;
import cryptix.asn1.tools.Generator;
import cryptix.asn1.tools.Interpreter;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PushbackReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$tools$Main != null ? class$Lcryptix$asn1$tools$Main : (class$Lcryptix$asn1$tools$Main = Main.class$("cryptix.asn1.tools.Main"))).getName());
    private static final LongOpt[] CLO = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("Destination", 2, null, 68), new LongOpt("Package", 1, null, 80)};
    private String destination = System.getProperty("user.dir");
    private String[] definitions = null;
    private Hashtable dict = new Hashtable();
    private boolean valid = false;
    private static /* synthetic */ Class class$Lcryptix$asn1$tools$Main;

    public static final void main(String[] stringArray) {
        Object object;
        try {
            PropertyConfigurator.configure((String)"log.properties");
        }
        catch (Exception exception) {
            String string = System.getProperty("user.dir", ".");
            object = System.getProperty("log.dir", string);
            PropertyConfigurator.configure((String)((String)object + File.separator + "log.properties"));
        }
        cat.info((Object)("Started on " + String.valueOf(new Date())));
        long l = -System.currentTimeMillis();
        object = new Main(stringArray);
        if (((Main)object).valid) {
            super.invoke();
        }
        cat.info((Object)("Finished. Process lasted " + String.valueOf(l += System.currentTimeMillis()) + "ms..."));
    }

    private static final void printUsage() {
        System.out.println();
        System.out.println("Cryptix ASN.1 Kit ASN.1-to-Java compiler");
        System.out.println("Copyright (C) 1997-2001 The Cryptix Foundation Limited.");
        System.out.println("All rights reserved.");
        System.out.println();
        System.out.println("$Revision: 1.3 $".replace('$', ' ').substring(1));
        System.out.println("$Date: 2001/03/26 20:24:29 $".replace('$', ' ').substring(1));
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  java -jar cryptix-asn1.jar [options] [--] specification...");
        System.out.println("or");
        System.out.println("  java " + (class$Lcryptix$asn1$tools$Main != null ? class$Lcryptix$asn1$tools$Main : (class$Lcryptix$asn1$tools$Main = Main.class$("cryptix.asn1.tools.Main"))).getName() + " [options] [--] specification...");
        System.out.println();
        System.out.println("Where options are:");
        System.out.println("  -h");
        System.out.println("  --help");
        System.out.println("     Prints this text.");
        System.out.println("  -D[<directory>]");
        System.out.println("  --Destination=[<directory>]");
        System.out.println("     The name of the destination directory for generated sources.");
        System.out.println("     If unspecified, then the current directory is assumed.");
        System.out.println("  -P <module-name>=<package-name>");
        System.out.println("  -P<module-name>=<package-name>");
        System.out.println("  --Package=<module-name>=<package-name>");
        System.out.println("     The name of a package to map an ASN.1 module name to. This may");
        System.out.println("     be repeated as many times as required. If no mapping is found,");
        System.out.println("     the ASN.1 module name will be used as the package name.");
        System.out.println("  specification");
        System.out.println("     A non-empty, space separated, list of ASN.1 specifications");
        System.out.println("     file(s) to process.");
        System.out.println();
        System.out.println("Example:");
        System.out.println("  java -jar cryptix-asn1.jar \\");
        System.out.println("     -Dtmp \\");
        System.out.println("     -P CryptixUsefulDefinitions=cryptix.asn1.common \\");
        System.out.println("     -P PKCS-6=cryptix.asn1.pkc6 \\");
        System.out.println("     cryptix.asn pkcs6");
        System.out.println();
    }

    private boolean parseArgs(String[] stringArray) {
        int n;
        int n2;
        Getopt getopt = new Getopt(this.getClass().getName(), stringArray, "-:hD::P:", CLO);
        getopt.setOpterr(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = getopt.getopt()) != -1) {
            switch (n2) {
                case 63: {
                    cat.error((Object)"Invalid option. May be missing space after --");
                    throw new RuntimeException("May be missing space after --");
                }
                case 58: {
                    cat.error((Object)("Stuffed option " + String.valueOf(getopt.getOptopt())));
                    break;
                }
                case 0: {
                    cat.debug((Object)("Long option " + String.valueOf(getopt.getOptarg())));
                    break;
                }
                case 1: {
                    String string = getopt.getOptarg();
                    cat.debug((Object)("Non-optional argument \"" + string + "\""));
                    arrayList.add(string);
                    break;
                }
                case 104: {
                    return false;
                }
                case 68: {
                    String string = getopt.getOptarg();
                    cat.debug((Object)("Destination argument: \"" + String.valueOf(string) + "\""));
                    this.destination = string;
                    break;
                }
                case 80: {
                    String string = getopt.getOptarg();
                    cat.debug((Object)("Package argument: \"" + string + "\""));
                    n = string.indexOf("=");
                    if (n == -1) {
                        cat.error((Object)"Missing '=' in a Package option value.");
                        throw new RuntimeException("Malformed -P option value");
                    }
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    this.dict.put(string2, string3);
                    break;
                }
                default: {
                    cat.error((Object)("Unknown option: '" + String.valueOf((char)n2) + "'"));
                    throw new RuntimeException("Unknown option");
                }
            }
        }
        n = getopt.getOptind();
        int n3 = stringArray.length - n;
        while (n3-- > 0) {
            arrayList.add(stringArray[n++]);
        }
        n3 = arrayList.size();
        if (n3 < 1) {
            throw new RuntimeException("Missing specification file");
        }
        this.definitions = new String[arrayList.size()];
        arrayList.toArray(this.definitions);
        cat.info((Object)("Destination directory = " + this.destination));
        cat.info((Object)("Package name mappings = " + String.valueOf(this.dict)));
        cat.info((Object)("Specification file(s) = " + String.valueOf(arrayList)));
        cat.info((Object)"");
        return true;
    }

    private void invoke() {
        int n = 0;
        while (n < this.definitions.length) {
            this.compile(this.definitions[n]);
            ++n;
        }
    }

    private void compile(String string) {
        Object object;
        Object object2;
        File file = new File(string);
        if (!file.isFile()) {
            String string2 = "File " + file.getAbsolutePath() + " does not exist";
            cat.error((Object)string2);
            throw new RuntimeException(string2);
        }
        String string3 = file.getAbsolutePath();
        Start start = null;
        cat.info((Object)"");
        cat.info((Object)("Parsing ASN.1 specification in \"" + string3 + "\"..."));
        try {
            object2 = new Lexer(new PushbackReader(new BufferedReader(new FileReader(file), 4096)));
            object = new Parser((Lexer)object2);
            start = ((Parser)object).parse();
            cat.info((Object)start);
        }
        catch (Exception exception) {
            cat.error((Object)String.valueOf(exception));
            exception.printStackTrace(System.err);
            throw new RuntimeException("Error while parsing ASN.1 specifications");
        }
        cat.info((Object)"");
        cat.info((Object)("Interpreting ASN.1 specifications in \"" + string3 + "\"..."));
        object2 = new Interpreter();
        try {
            ((Node)start).apply((Switch)object2);
        }
        catch (Exception exception) {
            cat.error((Object)String.valueOf(exception));
            exception.printStackTrace(System.err);
            throw new RuntimeException("Error while interpreting ASN.1 specifications");
        }
        cat.info((Object)"");
        try {
            object = new File(this.destination);
            cat.info((Object)"Generating java source");
            Generator generator = new Generator((Interpreter)object2);
            generator.generate((File)object, this.dict);
        }
        catch (Exception exception) {
            cat.error((Object)String.valueOf(exception));
            exception.printStackTrace(System.err);
            throw new RuntimeException("Error while generating Java source");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Main(String[] stringArray) {
        try {
            this.valid = this.parseArgs(stringArray);
        }
        catch (Exception exception) {
            cat.error((Object)String.valueOf(exception));
            System.exit(1);
        }
        if (!this.valid) {
            Main.printUsage();
        }
    }
}

