/* $Id: TagMismatchException.java,v 1.1.1.1 2001/02/24 04:59:02 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.io;

/**
 * A subclass of ASNIOException class (checked exception) to denote that an
 * expected ASN.1 Tag was not found in the input stream.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class TagMismatchException extends ASNIOException {

	/**
	 * Constructs an <tt>TagMismatchException</tt> with the specified detail
	 * message. The error message string <tt>tag</tt> can later be retrieved by
	 * the <tt>getMessage()</tt> method of class <tt>java.lang.Throwable</tt>.
	 *
	 * @param tag the detail message, which in the case of this exception denotes
	 * the string representation of the ASN.1 Tag that was expected in the input
	 * stream.
	 */
	public TagMismatchException(String tag) {
		super(tag);
	}
}