/* $Id: IType.java,v 1.1.1.1 2001/02/24 04:59:04 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;

import java.io.IOException;
import java.io.Serializable;

/**
 * The visible methods of any ASN.1 type.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public interface IType extends Serializable {

	/**
	 * Return the Name of this object.
	 *
	 * @return the Name of this object.
	 */
	String getName();

	/**
	 * Sets the Name of this object to the designated value.
	 *
	 * @param name the Name of this object.
	 */
	void setName(String name);

	/**
	 * Returns the Tag instance of this object.
	 *
	 * @returns the Tag instance of this object.
	 */
	Tag getTag();

	/**
	 * Decodes an instance of this object from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	void decode(ASNReader is) throws IOException;

	/**
	 * Encodes an instance of this object to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	void encode(ASNWriter os) throws IOException;

	/**
	 * Resets the current value of this instance to blank (initial value).
	 */
	void reset();

	/**
	 * Returns the current value of this instance.
	 *
	 * @return the current value of this instance.
	 */
	Object getValue();

	/**
	 * Sets the current value of this instance to the designated one.
	 *
	 * @param value the new value to assign to this instance.
	 */
	void setValue(Object value);

	/**
	 * Returns the default value of this instance.
	 *
	 * @return the default value of this instance.
	 */
	Object getDefaultValue();

	/**
	 * Sets the default value of this instance to the designated one.
	 *
	 * @param value the new default value to assign to this instance.
	 */
	void setDefaultValue(Object defaultValue);

	/**
	 * Returns true if this type --when used as a constituant of a compound type
	 * -- is optional or not.
	 *
	 * @return true if this type is optional; false otherwise.
	 */
	boolean isOptional();

	/**
	 * Sets the optional flag of this instance to the designated one.
	 *
	 * @param optional the new optional flag of this instance.
	 */
	void setOptional(boolean optional);

	/**
	 * Returns true if the value of this instance is not set.
	 *
	 * @return true if this instance's value is not set.
	 */
	boolean isBlank();
}