/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.encoding;

import cryptix.asn1.encoding.DerFormatException;
import cryptix.asn1.encoding.DerInvalidLengthException;
import cryptix.asn1.encoding.DerLengthMismatchException;
import cryptix.asn1.encoding.DerObjectTooLargeException;
import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.TagMismatchException;
import cryptix.asn1.lang.ASNBoolean;
import cryptix.asn1.lang.ASNInteger;
import cryptix.asn1.lang.Any;
import cryptix.asn1.lang.BMPString;
import cryptix.asn1.lang.BitString;
import cryptix.asn1.lang.GeneralString;
import cryptix.asn1.lang.GeneralizedTime;
import cryptix.asn1.lang.GraphicString;
import cryptix.asn1.lang.IA5String;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Null;
import cryptix.asn1.lang.NumericString;
import cryptix.asn1.lang.ObjectIdentifier;
import cryptix.asn1.lang.OctetString;
import cryptix.asn1.lang.PrintableString;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.TeletexString;
import cryptix.asn1.lang.Type;
import cryptix.asn1.lang.UTCTime;
import cryptix.asn1.lang.UniversalString;
import cryptix.asn1.lang.VideotexString;
import cryptix.asn1.lang.VisibleString;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Category;

public class DerDecoder
extends ASNReader {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$encoding$DerDecoder != null ? class$Lcryptix$asn1$encoding$DerDecoder : (class$Lcryptix$asn1$encoding$DerDecoder = DerDecoder.class$("cryptix.asn1.encoding.DerDecoder"))).getName());
    BufferedInputStream in;
    private static /* synthetic */ Class class$Lcryptix$asn1$encoding$DerDecoder;

    private static final boolean eval(int n, int n2, int n3, int n4) {
        cat.info((Object)("Comparing [" + n + ", " + n3 + "] to [" + n2 + ", " + n4 + "]"));
        if (n != n2) {
            return false;
        }
        if (n == 64 || n == 192) {
            return n3 == n4;
        }
        if (n3 == n4) {
            return true;
        }
        if (n4 > 32) {
            n4 -= 32;
        }
        if (n4 == 19 || n4 == 22 || n4 == 20) {
            return n3 == 19 || n3 == 22 || n3 == 20;
        }
        if (n4 == 16 || n4 == 48 || n4 == 17 || n4 == 49) {
            return n3 == 16 || n3 == 48 || n3 == 17 || n3 == 49;
        }
        return false;
    }

    private static final Date toDate(byte[] byArray) throws DerFormatException {
        int n = byArray.length;
        if (n != 11 && n != 13 && n != 15 && n != 17) {
            throw new DerFormatException(23);
        }
        if (n == 11 && byArray[10] != 90) {
            throw new DerFormatException(23);
        }
        if (n == 13 && byArray[12] != 90) {
            throw new DerFormatException(23);
        }
        if (n == 15 && (byArray[10] != 43 || byArray[10] != 45)) {
            throw new DerFormatException(23);
        }
        if (n == 17 && (byArray[12] != 43 || byArray[12] != 45)) {
            throw new DerFormatException(23);
        }
        int n2 = (byArray[0] - 48) * 10 + (byArray[1] - 48);
        int n3 = (byArray[2] - 48) * 10 + (byArray[3] - 48) - 1;
        int n4 = (byArray[4] - 48) * 10 + (byArray[5] - 48);
        int n5 = (byArray[6] - 48) * 10 + (byArray[7] - 48);
        int n6 = (byArray[8] - 48) * 10 + (byArray[9] - 48);
        n2 += n2 <= 50 ? 2000 : 1900;
        Date date = null;
        Calendar calendar = null;
        int n7 = 0;
        switch (n) {
            case 11: {
                calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.set(n2, n3, n4, n5, n6);
                date = calendar.getTime();
                break;
            }
            case 13: {
                calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                n7 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
                calendar.set(n2, n3, n4, n5, n6, n7);
                date = calendar.getTime();
                break;
            }
            case 15: {
                calendar = Calendar.getInstance();
                calendar.set(n2, n3, n4, n5, n6);
                n5 = (byArray[11] - 48) * 10 + (byArray[12] - 48);
                n6 = (byArray[13] - 48) * 10 + (byArray[14] - 48);
                n6 += n5 * 60;
                if (byArray[10] == 43) {
                    calendar.add(12, n6);
                } else {
                    calendar.add(12, -n6);
                }
                date = calendar.getTime();
                break;
            }
            case 17: {
                calendar = Calendar.getInstance();
                n7 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
                calendar.set(n2, n3, n4, n5, n6, n7);
                n5 = (byArray[13] - 48) * 10 + (byArray[14] - 48);
                n6 = (byArray[15] - 48) * 10 + (byArray[16] - 48);
                n6 += n5 * 60;
                if (byArray[12] == 43) {
                    calendar.add(12, n6);
                } else {
                    calendar.add(12, -n6);
                }
                date = calendar.getTime();
            }
        }
        return date;
    }

    private static final Date toFullDate(byte[] byArray) throws DerFormatException {
        int n = byArray.length;
        if (n < 13) {
            throw new DerFormatException(24);
        }
        int n2 = (byArray[0] - 48) * 1000 + (byArray[1] - 48) * 100 + (byArray[2] - 48) * 10 + (byArray[3] - 48);
        int n3 = (byArray[4] - 48) * 10 + (byArray[5] - 48) - 1;
        int n4 = (byArray[6] - 48) * 10 + (byArray[7] - 48);
        int n5 = (byArray[8] - 48) * 10 + (byArray[9] - 48);
        int n6 = (byArray[10] - 48) * 10 + (byArray[11] - 48);
        Date date = null;
        Calendar calendar = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        if (byArray[n - 1] == 90) {
            int n11 = 12;
            while (n11 < n - 1) {
                if ((n10 = byArray[n11++] & 0xFF) == 46) {
                    bl = true;
                    continue;
                }
                if (!bl) {
                    n7 = n7 * 10 + (n10 - 48);
                    continue;
                }
                if (n9++ >= 3) continue;
                n8 = n8 * 10 + (n10 - 48);
            }
            calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            calendar.set(n2, n3, n4, n5, n6, n7);
            calendar.set(14, n8);
        } else {
            boolean bl2;
            int n12 = 12;
            while (byArray[n12] != 43 && byArray[n12] != 45 && n12 < n) {
                if ((n10 = byArray[n12++] & 0xFF) == 46) {
                    bl = true;
                    continue;
                }
                if (!bl) {
                    n7 = n7 * 10 + (n10 - 48);
                    continue;
                }
                if (n9++ >= 3) continue;
                n8 = n8 * 10 + (n10 - 48);
            }
            if (n12 == n) {
                throw new DerFormatException(24);
            }
            calendar = Calendar.getInstance();
            calendar.set(n2, n3, n4, n5, n6, n7);
            calendar.set(14, n8);
            boolean bl3 = bl2 = byArray[n12++] == 45;
            if (n - n12 != 4) {
                throw new DerFormatException(24);
            }
            n5 = (byArray[n12++] - 48) * 10 + (byArray[n12++] - 48);
            n6 = (byArray[n12++] - 48) * 10 + (byArray[n12++] - 48);
            n6 += n5 * 60;
            if (bl2) {
                n6 *= -1;
            }
            calendar.add(12, n6);
        }
        date = calendar.getTime();
        return date;
    }

    private static final String toOID(byte[] byArray) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = byArray.length;
        int n4 = 0;
        if (--n3 >= 0) {
            n = (n2 = byArray[n4++] & 0xFF) < 40 ? 0 : (n2 < 80 ? 1 : 2);
            int n5 = n2 - n * 40;
            stringBuffer.append(n).append(".").append(n5);
        }
        while (n3 > 0) {
            stringBuffer.append(".");
            n2 = 0;
            do {
                n = byArray[n4++] & 0xFF;
                n2 = n2 << 7 | n & 0x7F;
            } while (--n3 > 0 && (n & 0x80) == 128);
            stringBuffer.append(n2);
        }
        String string = stringBuffer.toString();
        return string;
    }

    private static final Boolean toBoolean(byte[] byArray) throws DerInvalidLengthException {
        int n = byArray.length;
        if (n != 1) {
            throw new DerInvalidLengthException(1, n, 1);
        }
        Boolean bl = new Boolean(byArray[0] != 0);
        return bl;
    }

    private static final void toNull(byte[] byArray) throws DerInvalidLengthException {
        int n = byArray.length;
        if (n != 0) {
            throw new DerInvalidLengthException(5, n, 0);
        }
    }

    public void open(InputStream inputStream) {
        if (this.in != null) {
            throw new IllegalStateException();
        }
        this.in = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, 10240);
    }

    public IType decodeAny(String string) throws IOException {
        cat.debug((Object)("==> decodeAny(" + string + ")"));
        Tag tag = null;
        tag = this.readTag();
        int n = this.readLength();
        byte[] byArray = new byte[n];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != n) {
            throw new DerLengthMismatchException(n2, n);
        }
        Type type = null;
        if (tag.getClazz() == 0) {
            switch (tag.getValue()) {
                case 1: {
                    type = new ASNBoolean(string, tag, DerDecoder.toBoolean(byArray));
                    break;
                }
                case 2: {
                    type = new ASNInteger(string, tag, new BigInteger(1, byArray));
                    break;
                }
                case 3: {
                    type = new BitString(string, tag, byArray);
                    break;
                }
                case 4: {
                    type = new OctetString(string, tag, byArray);
                    break;
                }
                case 5: {
                    DerDecoder.toNull(byArray);
                    type = new Null(string, tag, new Object());
                    break;
                }
                case 6: {
                    type = new ObjectIdentifier(string, tag, DerDecoder.toOID(byArray));
                    break;
                }
                case 18: {
                    type = new NumericString(string, tag, new String(byArray, "ASCII"));
                    break;
                }
                case 19: {
                    type = new PrintableString(string, tag, new String(byArray, "ASCII"));
                    break;
                }
                case 20: {
                    type = new TeletexString(string, tag, new String(byArray, "ASCII"));
                    break;
                }
                case 21: {
                    type = new VideotexString(string, tag, new String(byArray, "ASCII"));
                    break;
                }
                case 22: {
                    type = new IA5String(string, tag, new String(byArray, "ASCII"));
                    break;
                }
                case 25: {
                    type = new GraphicString(string, tag, new String(byArray, "UTF8"));
                    break;
                }
                case 26: {
                    type = new VisibleString(string, tag, new String(byArray, "UTF8"));
                    break;
                }
                case 27: {
                    type = new GeneralString(string, tag, new String(byArray, "UTF8"));
                    break;
                }
                case 28: {
                    type = new UniversalString(string, tag, new String(byArray, "UTF8"));
                    break;
                }
                case 30: {
                    type = new BMPString(string, tag, new String(byArray, "UTF8"));
                    break;
                }
                case 23: {
                    type = new UTCTime(string, tag, DerDecoder.toDate(byArray));
                    break;
                }
                case 24: {
                    type = new GeneralizedTime(string, tag, DerDecoder.toFullDate(byArray));
                    break;
                }
                case 16: 
                case 17: 
                case 48: 
                case 49: {
                    ArrayList<IType> arrayList = new ArrayList<IType>();
                    DerDecoder derDecoder = new DerDecoder(byArray);
                    try {
                        while (true) {
                            arrayList.add(derDecoder.decodeAny("seq"));
                        }
                    }
                    catch (IOException iOException) {
                        type = new Any(string, tag, arrayList);
                        break;
                    }
                }
                default: {
                    cat.warn((Object)("Unable to parse an ANY; tag=" + String.valueOf(tag)));
                    type = new Any(string, tag, byArray);
                    break;
                }
            }
        } else if (tag.getClazz() == 128) {
            if (tag.isExplicit()) {
                DerDecoder derDecoder = new DerDecoder(byArray);
                type = new Any(string, tag, derDecoder.decodeAny("xxx"));
            } else {
                type = new Any(string, tag, byArray);
            }
        } else {
            type = new Any(string, tag, byArray);
        }
        cat.debug((Object)("<== decodeAny() --> " + type));
        return type;
    }

    public String decodeObjectIdentifier(IType iType) throws IOException {
        cat.debug((Object)"==> decodeObjectIdentifier()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 6);
        String string = DerDecoder.toOID(byArray);
        cat.debug((Object)("<== decodeObjectIdentifier() --> " + string));
        return string;
    }

    public void decodeNull(IType iType) throws IOException {
        cat.debug((Object)"==> decodeNull()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 5);
        DerDecoder.toNull(byArray);
        cat.debug((Object)"<== decodeNull()");
    }

    public Boolean decodeBoolean(IType iType) throws IOException {
        cat.debug((Object)"==> decodeBoolean()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 1);
        Boolean bl = DerDecoder.toBoolean(byArray);
        cat.debug((Object)("<== decodeBoolean() --> " + bl));
        return bl;
    }

    public BigInteger decodeInteger(IType iType) throws IOException {
        cat.debug((Object)"==> decodeInteger()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        cat.debug((Object)("<== decodeInteger() --> " + bigInteger));
        return bigInteger;
    }

    public String decodeString(int n, IType iType) throws IOException {
        cat.debug((Object)("==> decodeString(" + n + ")"));
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, n);
        String string = new String(byArray, "UTF8");
        cat.debug((Object)("<== decodeString() --> \"" + string + "\""));
        return string;
    }

    public byte[] decodeBitString(IType iType) throws IOException {
        cat.debug((Object)"==> decodeBitString()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 3);
        cat.warn((Object)("Truncating " + String.valueOf(byArray[0]) + " unused leftmost bit(s) from a BIT STRING"));
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
        cat.debug((Object)("<== decodeBitString() --> 0x" + new BigInteger(1, byArray2).toString(16)));
        return byArray2;
    }

    public byte[] decodeOctetString(IType iType) throws IOException {
        cat.debug((Object)"==> decodeOctetString()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 4);
        cat.debug((Object)("<== decodeOctetString() --> 0x" + new BigInteger(1, byArray).toString(16)));
        return byArray;
    }

    public Date decodeUTCTime(IType iType) throws IOException {
        cat.debug((Object)"==> decodeUTCTime()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 23);
        Date date = DerDecoder.toDate(byArray);
        cat.debug((Object)("<== decodeUTCTime() --> " + date));
        return date;
    }

    public Date decodeGeneralizedTime(IType iType) throws IOException {
        cat.debug((Object)"==> decodeGeneralizedTime()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 24);
        Date date = DerDecoder.toFullDate(byArray);
        cat.debug((Object)("<== decodeGeneralizedTime() --> " + date));
        return date;
    }

    public ASNReader decodeStructure(IType iType) throws IOException {
        cat.debug((Object)"==> decodeStructure()");
        Tag tag = iType.getTag();
        byte[] byArray = this.readRaw(tag, 16);
        DerDecoder derDecoder = new DerDecoder(byArray);
        cat.debug((Object)("<== decodeStructure() --> " + derDecoder));
        return derDecoder;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n & 0xFF;
    }

    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                cat.warn((Object)("I/O exception while closing the stream: " + iOException.getMessage()));
            }
            this.in = null;
        }
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    private byte[] readRaw(Tag tag, int n) throws IOException {
        byte[] byArray;
        byte[] byArray2 = this.readBytes(tag);
        if (tag.isExplicit() && !tag.isUniversal()) {
            DerDecoder derDecoder = new DerDecoder(byArray2);
            byArray = derDecoder.readBytes(new Tag(n));
        } else {
            byArray = byArray2;
        }
        return byArray;
    }

    private byte[] readBytes(Tag tag) throws IOException {
        int n = this.readTL(tag);
        byte[] byArray = new byte[n];
        int n2 = this.read(byArray);
        if (n2 == -1) {
            throw new EOFException();
        }
        if (n2 != n) {
            throw new DerLengthMismatchException(n2, n);
        }
        return byArray;
    }

    private int readTL(Tag tag) throws IOException {
        if (!this.isExpectedTag(tag)) {
            throw new TagMismatchException(String.valueOf(tag));
        }
        int n = this.readLength();
        return n;
    }

    private boolean isExpectedTag(Tag tag) throws IOException {
        Tag tag2 = this.getExpectedTag(tag.getClazz(), tag.getValue());
        return tag2 != null;
    }

    private Tag getExpectedTag(int n, int n2) throws IOException {
        int n3 = -1;
        int n4 = -1;
        Tag tag = null;
        try {
            cat.debug((Object)("==> getExpectedTag(" + n + ", " + n2 + ")"));
            int n5 = this.read();
            n3 = n5 & 0xC0;
            boolean bl = (n5 & 0x20) != 0;
            n4 = n5 & 0x1F;
            if (n4 == 31) {
                n4 = 0;
                do {
                    n5 = this.read();
                    n4 += n5 & 0x3F;
                } while ((n5 & 0x80) != 0);
            }
            tag = new Tag(n3, n4, true, bl);
            cat.info((Object)("Checking for Tag's [" + n + " " + n2 + "] found: " + tag));
        }
        finally {
            Object var7_8 = null;
            if (!DerDecoder.eval(n3, n, n4, n2)) {
                tag = null;
            }
        }
        cat.debug((Object)("<== getExpectedTag() --> " + tag + " [" + n3 + ", " + n4 + "]"));
        return tag;
    }

    private Tag readTag() throws IOException {
        cat.debug((Object)"==> readTag()");
        Tag tag = null;
        int n = this.read();
        int n2 = n & 0xC0;
        boolean bl = (n & 0x20) != 0;
        int n3 = n & 0x1F;
        if (n3 == 31) {
            n = this.read();
            n3 = n & 0x3F;
            while ((n & 0x80) != 0) {
                n = this.read();
                n3 += n & 0x3F;
            }
        }
        tag = new Tag(n2, n3, true, bl);
        cat.debug((Object)("<== readTag() --> " + tag));
        return tag;
    }

    private int readLength() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            if ((n2 &= 0x7F) > 4) {
                throw new DerObjectTooLargeException();
            }
            n = 0;
            while (n2-- > 0) {
                n = n << 8 | this.read() & 0xFF;
            }
        }
        cat.info((Object)("Element length = " + n));
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DerDecoder() {
    }

    private DerDecoder(byte[] byArray) {
        this.in = new BufferedInputStream(new ByteArrayInputStream(byArray), 10240);
    }
}

