/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Null;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.log4j.Category;

public class BitString
extends Type
implements IType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$BitString != null ? class$Lcryptix$asn1$lang$BitString : (class$Lcryptix$asn1$lang$BitString = BitString.class$("cryptix.asn1.lang.BitString"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$BitString;

    public static BitString getInstance(byte[] byArray) {
        return new BitString("", byArray);
    }

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        aSNReader.mark(Integer.MAX_VALUE);
        try {
            byte[] byArray = aSNReader.decodeBitString(this);
            if (byArray == null) {
                throw new ElementNotFoundException(string);
            }
            this.setValue(byArray);
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void encode(ASNWriter aSNWriter) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encode()"));
        Object object = this.getValue();
        if (object != null) {
            aSNWriter.encodeBitString(this, (byte[])object);
        } else {
            object = this.getDefaultValue();
            if (object != null) {
                cat.info((Object)("Encoding default value for " + string));
                aSNWriter.encodeBitString(this, (byte[])object);
            } else {
                if (!this.isOptional()) {
                    throw new BlankElementException(string);
                }
                cat.warn((Object)("Encoding a NULL for " + string));
                new Null(this.getConstructName()).encode(aSNWriter);
            }
        }
        cat.debug((Object)("<== " + string + ".encode()"));
    }

    public byte[] byteArrayValue() {
        return (byte[])this.value;
    }

    protected boolean sameValue(Object object) {
        byte[] byArray;
        if (object == null) {
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        byte[] byArray2 = this.byteArrayValue();
        if (byArray2 == null) {
            return false;
        }
        if (byArray2.length != byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        if (this.value != null) {
            stringBuffer.append(new BigInteger(1, this.byteArrayValue()).toString(2));
        } else {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BitString() {
        super("", new Tag(3));
    }

    public BitString(String string) {
        super(string, new Tag(3));
    }

    public BitString(String string, Tag tag) {
        super(string, tag);
    }

    public BitString(String string, Object object) {
        this(string, new Tag(3), object);
    }

    public BitString(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            this.value = (byte[])((byte[])object).clone();
        }
        if (this.value != null) {
            this.setDefaultValue(this.value);
        }
    }
}

