/*
 * Decompiled with CFR 0.152.
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;
import cryptix.asn1.lang.ASNException;
import cryptix.asn1.lang.IType;
import cryptix.asn1.lang.Null;
import cryptix.asn1.lang.Tag;
import cryptix.asn1.lang.Type;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Category;

public class ObjectIdentifier
extends Type
implements IType {
    static Category cat = Category.getInstance((String)(class$Lcryptix$asn1$lang$ObjectIdentifier != null ? class$Lcryptix$asn1$lang$ObjectIdentifier : (class$Lcryptix$asn1$lang$ObjectIdentifier = ObjectIdentifier.class$("cryptix.asn1.lang.ObjectIdentifier"))).getName());
    private static /* synthetic */ Class class$Lcryptix$asn1$lang$ObjectIdentifier;

    public static ObjectIdentifier getInstance(String string) {
        return new ObjectIdentifier("", string);
    }

    public static ObjectIdentifier getInstance(ObjectIdentifier objectIdentifier) {
        return new ObjectIdentifier("", objectIdentifier);
    }

    public void decode(ASNReader aSNReader) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".decode()"));
        aSNReader.mark(Integer.MAX_VALUE);
        try {
            String string2 = aSNReader.decodeObjectIdentifier(this);
            if (string2 == null) {
                throw new ElementNotFoundException(string);
            }
            this.setValue(string2);
        }
        catch (IOException iOException) {
            cat.warn((Object)("Exception (" + String.valueOf(iOException) + ") encountered while decoding a " + string));
            if (iOException instanceof ASNException || iOException instanceof EOFException) {
                cat.warn((Object)"Resetting input stream...");
                aSNReader.reset();
            }
            throw iOException;
        }
        cat.debug((Object)("<== " + string + ".decode()"));
    }

    public void encode(ASNWriter aSNWriter) throws IOException {
        String string = this.getClass().getName();
        cat.debug((Object)("==> " + string + ".encode()"));
        Object object = this.getValue();
        if (object != null) {
            aSNWriter.encodeObjectIdentifier(this, (String)object);
        } else {
            object = this.getDefaultValue();
            if (object != null) {
                cat.warn((Object)("Encoding default value for " + string));
                aSNWriter.encodeObjectIdentifier(this, (String)object);
            } else {
                if (!this.isOptional()) {
                    throw new BlankElementException(string);
                }
                cat.warn((Object)("Encoding a NULL for " + string));
                new Null(this.getConstructName()).encode(aSNWriter);
            }
        }
        cat.debug((Object)("<== " + string + ".encode()"));
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            this.value = (String)object;
        } else if (object instanceof ObjectIdentifier) {
            this.value = ((ObjectIdentifier)object).stringValue();
        } else {
            throw new ClassCastException();
        }
    }

    public String stringValue() {
        return (String)this.value;
    }

    protected boolean sameValue(Object object) {
        String string = this.stringValue();
        return string == null ? false : string.equals(object);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("-- ");
        if (this.value != null) {
            stringBuffer.append(this.stringValue());
        } else {
            stringBuffer.append("N/A");
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ObjectIdentifier() {
        super("", new Tag(6));
    }

    public ObjectIdentifier(String string) {
        super(string, new Tag(6));
    }

    public ObjectIdentifier(String string, Tag tag) {
        super(string, tag);
    }

    public ObjectIdentifier(String string, Object object) {
        this(string, new Tag(6), object);
    }

    public ObjectIdentifier(String string, Tag tag, Object object) {
        super(string, tag);
        if (object != null) {
            if (object instanceof String) {
                this.setValue(object);
            } else {
                throw new ClassCastException();
            }
        }
        if (this.value != null) {
            this.setDefaultValue(this.value);
        }
    }
}

