/* $Id: DerInvalidLengthException.java,v 1.1.1.1 2001/02/24 04:58:58 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.EncodingException;

/**
 * A subclass of <tt>EncodingException</tt> class (checked exception) to
 * denote that the parsed size of the data to read from the stream (in number
 * of bytes) does not match the value expected for a specific ASN.1 type.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class DerInvalidLengthException extends EncodingException {

	// Constants and vars
	// .......................................................................

	/**
	 * The ID of the ASN.1 UNIVERSAL type for which a length mismatch was
	 * detected.
	 */
	private int typeID;

	/**
	 * The expected length value. This is what got parsed in the Length part of
	 * the DER triplet.
	 */
	private int expectedLength;

	/**
	 * The actual number of bytes, constituting the size/length of the element
	 * itself.
	 */
	private int actualLength;

	// Constructor(s)
	// .......................................................................

	/**
	 * Constructs a <tt>DerLengthMismatchException</tt> with no detail message.
	 *
	 * @param tagValue the ID of the ASN.1 UNIVERSAL type. It is the same value
	 * as that of the type's Tag value field instance; ie. that returned by the
	 * <tt>getValue()</tt> method when invoked on this element's Tag instance.
	 * @param xLength the known pre-determined length value of the designated
	 * type.
	 * @param aLength the expected (parsed from the Length part of the DER
	 * triplet) length value.
	 */
	public DerInvalidLengthException(int tagValue, int xLength, int aLength) {
		super("DER");

		this.typeID = tagValue;
		this.expectedLength = xLength;
		this.actualLength = aLength;
	}

	// Instance methods
	// .......................................................................

	/**
	 * Returns an identifier of the UNIVERSAL type for which a length mismatch
	 * was detected.
	 *
	 * @return an ID of the type for which the mismatch was detected.
	 */
	public int getTypeID() {
		return (this.typeID);
	}

	/**
	 * Returns the expected size in bytes of the element in the stream.
	 *
	 * @return the expected size of the element's encoding.
	 */
	public int getExpectedLength() {
		return (this.expectedLength);
	}

	/**
	 * Returns the actual size in bytes of the element in the stream.
	 *
	 * @return the actual size of the element's encoding.
	 */
	public int getActualLength() {
		return (this.actualLength);
	}
}