/* $Id: DerObjectTooLargeException.java,v 1.1.1.1 2001/02/24 04:58:58 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.encoding;

import cryptix.asn1.io.EncodingException;

/**
 * A subclass of <tt>EncodingException</tt> class (checked exception) to denote
 * that the Length part of the DER triplet exceeds 32-bit.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class DerObjectTooLargeException extends EncodingException {

	/**
	 * Constructs an <tt>DerObjectTooLargeException</tt> with no detail message.
	 * Later, invoking the <tt>getMessage()</tt> method of the superclass
	 * <tt>java.lang.Throwable</tt> will return the string constant "DER".
	 */
	public DerObjectTooLargeException() {
		super("DER");
	}
}