/* $Id: ASNIOException.java,v 1.1.1.1 2001/02/24 04:59:02 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.io;

import cryptix.asn1.lang.ASNException;

/**
 * A subclass of ASNException class (checked exception) to denote that a
 * general stream input/output exception has occured.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class ASNIOException extends ASNException {

	/**
	 * Constructs an <tt>ASNIOException</tt> with the specified detail message.
	 * The error message string <tt>detail</tt> can later be retrieved by the
	 * <tt>getMessage()</tt> method of class <tt>java.lang.Throwable</tt>.
	 *
	 * @param detail the detail message.
	 */
	public ASNIOException(String detail) {
		super(detail);
	}
}