/* $Id: IA5String.java,v 1.1.1.1 2001/02/24 04:59:04 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.io.ASNReader;
import cryptix.asn1.io.ASNWriter;
import cryptix.asn1.io.BlankElementException;
import cryptix.asn1.io.ElementNotFoundException;

import org.apache.log4j.Category;

import java.io.EOFException;
import java.io.IOException;

/**
 * The basic implementation of an ASN.1 IA5String type.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class IA5String extends ASNString implements IType {

	// Constants and vars
	// .......................................................................

	static Category cat = Category.getInstance(IA5String.class.getName());

	// Constructor(s)
	// .......................................................................

	public IA5String() {
		super("", new Tag(Tag.IA5_STRING));
	}

	public IA5String(String name) {
		super(name, new Tag(Tag.IA5_STRING));
	}

	public IA5String(String name, Tag tag) {
		super(name, tag);
	}

	public IA5String(String name, Object value) {
		this(name, new Tag(Tag.IA5_STRING), value);
	}

	/**
	 * Constructs a new instance of a IA5String type, given a designated
	 * Tag and a designated initial value.
	 *
	 * @param name the name of this instance.
	 * @param tag the designated Tag value.
	 * @param value the designated initial value. Allowed types are:
	 * <tt>java.lang.String</tt>, and any subclass of <tt>cryptix.asn1.lang.ASNString</tt>.
	 * @exception ClassCastException if the designated value is not a String.
	 */
	public IA5String(String name, Tag tag, Object value) {
		super(name, tag);

		setValue(value);

		if (this.value != null)
			setDefaultValue(this.value);
	}

	// Class methods
	// .......................................................................

	/**
	 * Returns a new instance of this type with a trivial name and the
	 * designated value.
	 *
	 * @param value a designated initial value for the new instance.
	 * @return a new instance with the designated value.
	 * @exception ClassCastException if the designated value is not appropriate
	 * (see constructor with 3 arguments for suitable types of value).
	 */
	public static IA5String getInstance(String value) {
		return new IA5String("", value);
	}

	/**
	 * Returns a new instance of this type with a trivial name and the
	 * designated value.
	 *
	 * @param value a designated initial value for the new instance.
	 * @return a new instance with the designated value.
	 * @exception ClassCastException if the designated value is not appropriate
	 * (see constructor with 3 arguments for suitable types of value).
	 */
	public static IA5String getInstance(ASNString value) {
		return new IA5String("", value);
	}

	// Redefinition of methods in superclass Type
	// .......................................................................

	/**
	 * Decodes a IA5String from an input stream.
	 *
	 * @param is the ASN.1 stream to read from.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void decode(ASNReader is) throws IOException {
		this.decodeInternal(is, Tag.IA5_STRING);
	}

	/**
	 * Encodes a IA5String to an output stream.
	 *
	 * @param os the ASN.1 stream to write to.
	 * @exception IOException if an exception occurs during the operation.
	 */
	public void encode(ASNWriter os) throws IOException {
		this.encodeInternal(os, Tag.IA5_STRING);
	}
}