/* $Id: NodeInfo.java,v 1.1.1.1 2001/02/24 04:59:04 raif Exp $
 *
 * Copyright (C) 1997-2001 The Cryptix Foundation Limited. All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General Licence along with this library; if
 * not, you can download a copy from http://www.cryptix.org/
 */
package cryptix.asn1.lang;

import cryptix.asn1.analysis.DepthFirstAdapter;
import cryptix.asn1.node.Node;

/**
 * An immutable object to group a parsed sequence/set element data.<p>
 *
 * @version $Revision: 1.1.1.1 $
 * @author  Raif S. Naffah
 */
public class NodeInfo {

	// Constants and vars
	// .......................................................................

	private String name;
	private String type;
	private String tag;
	private Node n;
	private transient String sf; // string form of this object. cached for speed

	// Constructor(s)
	// .......................................................................

	/**
	 * Trivial constructor.
	 *
	 * @param name the user-defined name of the ASN.1 type.
	 * @param type the basic ASN.1 type which is the superclass of this type.
	 * @param tag the tag instance for this new type.
	 * @param n the SableCC Node instance containing additional AST info about
	 * this type, which the Interpreter may use.
	 */
	public NodeInfo(String name, String type, String tag, Node n) {
		this.name = name;
		this.type = type;
		this.tag = tag;
		this.n = n;
	}

	// Instance methods
	// .......................................................................

	/**
	 * Returns the type's user-defined name.
	 *
	 * @return the type's user-defined name.
	 */
	public String getElementName() {
		return (this.name);
	}

	/**
	 * Returns the superclass of this type.
	 *
	 * @return the superclass of this type.
	 */
	public String getElementType() {
		return (this.type);
	}

	/**
	 * Returns the tag instance attached to this type.
	 *
	 * @return the tag instance attached to this type.
	 */
	public String getTagValue() {
		return (this.tag);
	}

	/**
	 * Returns the SableCC Node instance attached to this type.
	 *
	 * @return the SableCC Node instance attached to this type.
	 */
	public Node getTypeSpecs() {
		return (this.n);
	}

	/**
	 * Returns a string form of this instance.
	 *
	 * @return a string form of this instance.
	 */
	public String toString() {
		if (sf == null) {
			StringBuffer sb = new StringBuffer();
			sb.append(name).append("; ");
			sb.append(type).append("; ");
			sb.append(tag).append("; ");
			sb.append(String.valueOf(n));
			sf = sb.toString();
		}
		return (sf);
	}
}